/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.homescreen;

import android.content.Context;
import android.view.View;
import androidx.annotation.VisibleForTesting;
import androidx.recyclerview.widget.RecyclerView;
import com.intercom.commons.utilities.ScreenUtils;
import com.intercom.commons.utilities.TimeProvider;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;
import java.util.List;

public class HomePresenter {
    private static final int CONTENT_OFFSET_DP = 64;

    public HomePresenter(Store<State> store, Provider<AppConfig> appConfigProvider, List<Object> cardList, MetricTracker metricTracker) {
        this(store, appConfigProvider, TimeProvider.SYSTEM, cardList, metricTracker);
    }

    @VisibleForTesting
    HomePresenter(Store<State> store, Provider<AppConfig> appConfigProvider, TimeProvider timeProvider, List<Object> cardList, MetricTracker metricTracker) {
    }

    public void renderHeaderScrollChange(RecyclerView cardList, int startLocationY, View closeBackground, View toolbarContent) {
        View firstCard = cardList.getChildAt(0);
        if (firstCard != null) {
            int[] firstCardLocation = new int[2];
            firstCard.getLocationInWindow(firstCardLocation);
            int currentLocationY = firstCardLocation[1];
            float scrollPercentAsDecimal = this.clamp((float)currentLocationY * 100.0f / (float)startLocationY) / 100.0f;
            closeBackground.setAlpha(this.inverseDecimalPercentage(scrollPercentAsDecimal));
            toolbarContent.setAlpha(scrollPercentAsDecimal);
            toolbarContent.setTranslationY((float)ScreenUtils.dpToPx((float)64.0f, (Context)toolbarContent.getContext()) * -this.inverseDecimalPercentage(scrollPercentAsDecimal));
        }
    }

    private float inverseDecimalPercentage(float percent) {
        return 1.0f - percent;
    }

    private float clamp(float value) {
        return Math.min(Math.max(value, 0.0f), 100.0f);
    }
}

