/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.widget.ImageView;
import coil.ComponentRegistry;
import coil.ImageLoader;
import coil.ImageLoaders;
import coil.decode.Decoder;
import coil.decode.GifDecoder;
import coil.decode.ImageDecoderDecoder;
import coil.request.ImageRequest;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0018\u0010\n\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0000\"\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"imageLoader", "Lcoil/ImageLoader;", "cleanUp", "", "clearIntercomImage", "imageView", "Landroid/widget/ImageView;", "getImageLoader", "context", "Landroid/content/Context;", "loadIntercomImage", "imageRequest", "Lcoil/request/ImageRequest;", "loadIntercomImageBlocking", "Landroid/graphics/drawable/Drawable;", "intercom-sdk-base_release"})
public final class IntercomCoilKt {
    @Nullable
    private static ImageLoader imageLoader;

    public static final void loadIntercomImage(@NotNull Context context, @NotNull ImageRequest imageRequest) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)imageRequest, (String)"imageRequest");
        IntercomCoilKt.getImageLoader(context).enqueue(imageRequest);
    }

    @Nullable
    public static final Drawable loadIntercomImageBlocking(@NotNull Context context, @NotNull ImageRequest imageRequest) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)imageRequest, (String)"imageRequest");
        return ImageLoaders.executeBlocking((ImageLoader)IntercomCoilKt.getImageLoader(context), (ImageRequest)imageRequest).getDrawable();
    }

    public static final void clearIntercomImage(@NotNull ImageView imageView) {
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
        Context context = imageView.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"imageView.context");
        ImageRequest clearImageRequest = new ImageRequest.Builder(context).data(null).build();
        context = imageView.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"imageView.context");
        IntercomCoilKt.getImageLoader(context).enqueue(clearImageRequest);
    }

    public static final void cleanUp() {
    }

    /*
     * WARNING - void declaration
     */
    private static final ImageLoader getImageLoader(Context context) {
        if (imageLoader == null) {
            void $this$getImageLoader_u24lambda_u2d0;
            ImageLoader.Builder this_$iv = new ImageLoader.Builder(context).bitmapConfig(Bitmap.Config.ARGB_8888);
            boolean $i$f$componentRegistry = false;
            ComponentRegistry.Builder builder = new ComponentRegistry.Builder();
            boolean bl = false;
            boolean bl2 = false;
            ComponentRegistry.Builder builder2 = builder;
            ImageLoader.Builder builder3 = this_$iv;
            boolean bl3 = false;
            if (Build.VERSION.SDK_INT >= 28) {
                $this$getImageLoader_u24lambda_u2d0.add((Decoder)new ImageDecoderDecoder(context));
            } else {
                $this$getImageLoader_u24lambda_u2d0.add((Decoder)new GifDecoder(false, 1, null));
            }
            Unit unit = Unit.INSTANCE;
            imageLoader = builder3.componentRegistry(builder.build()).build();
        }
        ImageLoader imageLoader = IntercomCoilKt.imageLoader;
        Intrinsics.checkNotNull((Object)imageLoader);
        return imageLoader;
    }
}

