/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.helpcenter.utils;

import android.content.Context;
import android.content.Intent;
import io.intercom.android.sdk.helpcenter.articles.ArticleActivity;
import io.intercom.android.sdk.helpcenter.collections.IntercomHelpCenterActivity;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007H\u0000\u001a\u001e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007H\u0000\u001a\u001e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007H\u0002\u001a \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001H\u0000\u001a \u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0001H\u0000\u00a8\u0006\u0012"}, d2={"extractIdFromLastSegment", "", "lastSegment", "isHelpCenterArticleUrl", "", "url", "helpCenterUrls", "", "isHelpCenterCollectionUrl", "isHelpCenterUrl", "openArticle", "", "context", "Landroid/content/Context;", "articleId", "place", "openCollection", "collectionId", "intercom-sdk-base_release"})
public final class HelpCenterUrlUtilsKt {
    public static final boolean isHelpCenterArticleUrl(@NotNull String url, @NotNull Set<String> helpCenterUrls) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(helpCenterUrls, (String)"helpCenterUrls");
        return HelpCenterUrlUtilsKt.isHelpCenterUrl(url, helpCenterUrls) && StringsKt.contains$default((CharSequence)url, (CharSequence)"/articles/", (boolean)false, (int)2, null);
    }

    public static final boolean isHelpCenterCollectionUrl(@NotNull String url, @NotNull Set<String> helpCenterUrls) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(helpCenterUrls, (String)"helpCenterUrls");
        return HelpCenterUrlUtilsKt.isHelpCenterUrl(url, helpCenterUrls) && StringsKt.contains$default((CharSequence)url, (CharSequence)"/collections/", (boolean)false, (int)2, null);
    }

    @NotNull
    public static final String extractIdFromLastSegment(@NotNull String lastSegment) {
        Intrinsics.checkNotNullParameter((Object)lastSegment, (String)"lastSegment");
        Object object = new String[]{"-"};
        List split = StringsKt.split$default((CharSequence)lastSegment, (String[])object, (boolean)false, (int)0, (int)6, null);
        object = split;
        boolean bl = false;
        if (!object.isEmpty()) {
            return (String)split.get(0);
        }
        return "";
    }

    public static final void openArticle(@NotNull Context context, @NotNull String articleId, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intent intent = ArticleActivity.Companion.buildIntent(context, new ArticleActivity.ArticleActivityArguments(articleId, place));
        context.startActivity(intent);
    }

    public static final void openCollection(@NotNull Context context, @NotNull String collectionId2, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)collectionId2, (String)"collectionId");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intent intent = IntercomHelpCenterActivity.Companion.buildIntent(context, CollectionsKt.listOf((Object)collectionId2), place);
        context.startActivity(intent);
    }

    private static final boolean isHelpCenterUrl(String url, Set<String> helpCenterUrls) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = helpCenterUrls;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)url, (String)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

