/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.helpcenter.collections;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.RecyclerView;
import io.intercom.android.sdk.databinding.IntercomCollectionFullHelpCenterItemBinding;
import io.intercom.android.sdk.databinding.IntercomCollectionsListItemBinding;
import io.intercom.android.sdk.helpcenter.collections.CollectionListRow;
import io.intercom.android.sdk.helpcenter.collections.CollectionViewHolder;
import io.intercom.android.sdk.helpcenter.collections.CollectionsListViewHolder;
import io.intercom.android.sdk.helpcenter.collections.FullHelpCenterViewHolder;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B'\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J\u0018\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J\u0014\u0010\u0017\u001a\u00020\u00062\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u000bR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lio/intercom/android/sdk/helpcenter/collections/CollectionsListAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lio/intercom/android/sdk/helpcenter/collections/CollectionsListViewHolder;", "onCollectionClick", "Lkotlin/Function1;", "", "", "onFullHelpCenterClick", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "items", "", "Lio/intercom/android/sdk/helpcenter/collections/CollectionListRow;", "getItemCount", "", "getItemViewType", "position", "onBindViewHolder", "holder", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "updateItems", "collectionsList", "Companion", "intercom-sdk-base_release"})
public final class CollectionsListAdapter
extends RecyclerView.Adapter<CollectionsListViewHolder> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<String, Unit> onCollectionClick;
    @NotNull
    private final Function0<Unit> onFullHelpCenterClick;
    @NotNull
    private List<? extends CollectionListRow> items;
    public static final int COLLECTION_TYPE = 1;
    public static final int FULL_HELP_CENTER_TYPE = 2;

    public CollectionsListAdapter(@NotNull Function1<? super String, Unit> onCollectionClick, @NotNull Function0<Unit> onFullHelpCenterClick2) {
        Intrinsics.checkNotNullParameter(onCollectionClick, (String)"onCollectionClick");
        Intrinsics.checkNotNullParameter(onFullHelpCenterClick2, (String)"onFullHelpCenterClick");
        this.onCollectionClick = onCollectionClick;
        this.onFullHelpCenterClick = onFullHelpCenterClick2;
        this.items = CollectionsKt.emptyList();
    }

    @NotNull
    public CollectionsListViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        CollectionsListViewHolder collectionsListViewHolder;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        int n = viewType;
        if (n == 1) {
            ConstraintLayout constraintLayout = IntercomCollectionsListItemBinding.inflate(LayoutInflater.from((Context)parent.getContext()), parent, false).getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"inflate(\n                    LayoutInflater.from(parent.context),\n                    parent,\n                    false\n                ).root");
            collectionsListViewHolder = new CollectionViewHolder((View)constraintLayout, this.onCollectionClick);
        } else {
            TextView textView = IntercomCollectionFullHelpCenterItemBinding.inflate(LayoutInflater.from((Context)parent.getContext()), parent, false).getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"inflate(\n                    LayoutInflater.from(parent.context),\n                    parent,\n                    false\n                ).root");
            collectionsListViewHolder = new FullHelpCenterViewHolder((View)textView, this.onFullHelpCenterClick);
        }
        return collectionsListViewHolder;
    }

    public void onBindViewHolder(@NotNull CollectionsListViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        CollectionListRow item = this.items.get(position);
        holder.bind(item);
    }

    public int getItemViewType(int position) {
        int n;
        CollectionListRow collectionListRow = this.items.get(position);
        if (collectionListRow instanceof CollectionListRow.CollectionRow) {
            n = 1;
        } else if (collectionListRow instanceof CollectionListRow.FullHelpCenterRow) {
            n = 2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    public int getItemCount() {
        return this.items.size();
    }

    public final void updateItems(@NotNull List<? extends CollectionListRow> collectionsList) {
        Intrinsics.checkNotNullParameter(collectionsList, (String)"collectionsList");
        this.items = collectionsList;
        this.notifyDataSetChanged();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/intercom/android/sdk/helpcenter/collections/CollectionsListAdapter$Companion;", "", "()V", "COLLECTION_TYPE", "", "FULL_HELP_CENTER_TYPE", "intercom-sdk-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

