/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation.composer.galleryinput;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.TransitionDrawable;
import android.net.Uri;
import android.text.TextUtils;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import coil.request.ImageRequest;
import com.intercom.composer.ImageLoader;
import com.intercom.input.gallery.GalleryImage;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.utilities.IntercomCoilKt;

class GalleryImageLoader
implements ImageLoader {
    static GalleryImageLoader create() {
        return new GalleryImageLoader();
    }

    GalleryImageLoader() {
    }

    public void loadImageIntoView(GalleryImage image, ImageView view) {
        String previewPath = image.getPreviewPath();
        Uri imageUri = TextUtils.isEmpty((CharSequence)previewPath) ? image.getUri() : Uri.parse((String)previewPath);
        Context context = view.getContext();
        ImageRequest imageRequest = new ImageRequest.Builder(context).data((Object)imageUri).target(view).crossfade(true).placeholder((Drawable)new ColorDrawable(ContextCompat.getColor((Context)context, (int)R.color.intercom_search_bg_grey))).build();
        IntercomCoilKt.loadIntercomImage(context, imageRequest);
    }

    private void logErrorMessageForUrl(Exception e, String url) {
        Twig twig = LumberMill.getLogger();
        String messageStart = "Failed to load image for URL: " + url + " - ";
        if (e == null) {
            twig.e(messageStart + "no error message, data probably failed to decode", new Object[0]);
        } else {
            twig.e(messageStart + e.getMessage(), new Object[0]);
        }
    }

    public void clear(ImageView imageView) {
        IntercomCoilKt.clearIntercomImage(imageView);
    }

    @Nullable
    public Bitmap getBitmapFromView(ImageView imageView) {
        Drawable drawable2 = imageView.getDrawable();
        if (drawable2 instanceof TransitionDrawable) {
            TransitionDrawable transitionDrawable = (TransitionDrawable)drawable2;
            for (int i = transitionDrawable.getNumberOfLayers() - 1; i >= 0; --i) {
                Bitmap realBitmap = this.getBitmapFromDrawable(transitionDrawable.getDrawable(i));
                if (realBitmap == null) continue;
                return realBitmap;
            }
            return null;
        }
        return this.getBitmapFromDrawable(drawable2);
    }

    @Nullable
    private Bitmap getBitmapFromDrawable(Drawable drawable2) {
        if (drawable2 instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        return null;
    }
}

