/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks.messengercard;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.net.Uri;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.FrameLayout;
import androidx.annotation.ColorInt;
import com.google.gson.Gson;
import com.squareup.otto.Bus;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.messengercard.CardWebView;
import io.intercom.android.sdk.blocks.messengercard.MessengerCardWebViewClient;
import io.intercom.android.sdk.blocks.messengercard.MessengerCardWebViewInterface;
import io.intercom.android.sdk.metrics.MetricTracker;
import java.io.File;

public class MessengerCardWebViewPresenter {
    private final CardWebView webView;
    private final View loadingView;
    private final String fallbackUrl;
    private final Bus bus;
    @ColorInt
    private final int primaryColor;
    private final Gson gson;
    private final MetricTracker metricTracker;
    private final String conversationId;
    private final File cache;
    private final boolean isHomeScreen;
    private final Activity activity;

    public MessengerCardWebViewPresenter(CardWebView webView, View loadingView, String fallbackUrl, Bus bus, @ColorInt int primaryColor, Gson gson, MetricTracker metricTracker, File cache, String conversationId, boolean isHomeScreen, Activity activity) {
        this.webView = webView;
        this.loadingView = loadingView;
        this.fallbackUrl = fallbackUrl;
        this.bus = bus;
        this.primaryColor = primaryColor;
        this.gson = gson;
        this.metricTracker = metricTracker;
        this.conversationId = conversationId;
        this.cache = cache;
        this.isHomeScreen = isHomeScreen;
        this.activity = activity;
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public void setUpWebView() {
        this.webView.setUp(this.bus);
        this.webView.setBackgroundColor(0);
        this.webView.setWebViewClient(new MessengerCardWebViewClient(Uri.parse((String)this.fallbackUrl).getHost()));
        WebView.setWebContentsDebuggingEnabled((boolean)true);
        WebSettings webSettings = this.webView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setUseWideViewPort(true);
        webSettings.setAppCacheEnabled(true);
        if (this.cache != null) {
            webSettings.setAppCachePath(this.cache.getAbsolutePath());
        }
        webSettings.setCacheMode(-1);
        webSettings.setMixedContentMode(0);
        this.webView.getSettings().setLayoutAlgorithm(WebSettings.LayoutAlgorithm.SINGLE_COLUMN);
        this.webView.setVerticalScrollBarEnabled(false);
        this.webView.setHorizontalScrollBarEnabled(false);
        MessengerCardWebViewInterface cardWebViewInterface = new MessengerCardWebViewInterface(this.webView, this.loadingView, this.gson, this.primaryColor, this.metricTracker, this.conversationId, this.isHomeScreen, this.activity);
        this.webView.addJavascriptInterface(cardWebViewInterface, "AndroidHost");
    }

    public static CardWebView createCardWebView(Context context) {
        CardWebView webView;
        try {
            webView = new CardWebView(context);
        }
        catch (Resources.NotFoundException e) {
            webView = new CardWebView((Context)Injector.get().getApplication());
        }
        webView.setAlpha(0.0f);
        webView.setId(R.id.intercom_messenger_card_webview);
        webView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        return webView;
    }
}

