/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.activities;

import android.content.Context;
import android.content.Intent;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.MediaController;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.VideoView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.activities.IntercomBaseActivity;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.imageloader.WallpaperLoader;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.video.AudioServiceContext;
import io.intercom.android.sdk.video.IntercomMediaController;
import io.intercom.android.sdk.views.IntercomToolbar;

public class IntercomVideoActivity
extends IntercomBaseActivity
implements IntercomToolbar.Listener,
View.OnClickListener {
    private static final String PARCEL_VIDEO_URL = "parcel_video_url";
    private ProgressBar loadingView;
    private VideoView videoView;
    private IntercomToolbar intercomToolbar;
    private WallpaperLoader wallpaperLoader;
    private FrameLayout videoViewOverlay;
    private MediaController mediaController;
    private MetricTracker metricTracker;

    public static Intent buildIntent(Context context, String videoUrl) {
        Intent intent = new Intent(context, IntercomVideoActivity.class);
        intent.putExtra(PARCEL_VIDEO_URL, videoUrl);
        intent.addFlags(0x10000000);
        intent.addFlags(0x20000000);
        return intent;
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.intercom_activity_video);
        this.loadingView = (ProgressBar)this.findViewById(R.id.loading_view);
        this.videoView = (VideoView)this.findViewById(R.id.video_view);
        this.intercomToolbar = (IntercomToolbar)this.findViewById(R.id.intercom_toolbar);
        this.videoViewOverlay = (FrameLayout)this.findViewById(R.id.video_view_overlay);
        Injector injector = Injector.get();
        Provider<AppConfig> appConfigProvider = injector.getAppConfigProvider();
        this.metricTracker = injector.getMetricTracker();
        this.setupToolbar(appConfigProvider);
        Bundle bundle = this.getIntent().getExtras();
        String videoUrl = bundle != null ? bundle.getString(PARCEL_VIDEO_URL, "") : "";
        this.overridePendingTransition(R.anim.intercom_video_slide_up_in, 0);
        if (!TextUtils.isEmpty((CharSequence)videoUrl)) {
            this.initVideoPlayer(videoUrl);
        } else {
            this.finish();
        }
    }

    protected void onStop() {
        this.videoView.stopPlayback();
        super.onStop();
    }

    @Override
    protected void onDestroy() {
        this.intercomToolbar.closeWallpaperLoader(this.wallpaperLoader);
        super.onDestroy();
    }

    public void onBackPressed() {
        this.closeActivity();
    }

    @Override
    protected void attachBaseContext(Context base) {
        super.attachBaseContext((Context)AudioServiceContext.preventLeakOf(base));
    }

    private void initVideoPlayer(final @NonNull String videoUrl) {
        this.mediaController = new IntercomMediaController((Context)this, this.intercomToolbar);
        this.videoView.setMediaController(this.mediaController);
        this.videoView.setVideoURI(Uri.parse((String)videoUrl));
        this.videoView.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mediaPlayer) {
                IntercomVideoActivity.this.metricTracker.loadedVideo(videoUrl, mediaPlayer.getVideoWidth(), mediaPlayer.getVideoHeight());
                IntercomVideoActivity.this.mediaController.show();
                IntercomVideoActivity.this.styleMediaController((View)IntercomVideoActivity.this.mediaController);
                IntercomVideoActivity.this.videoView.start();
                IntercomVideoActivity.this.loadingView.setVisibility(8);
                IntercomVideoActivity.this.videoViewOverlay.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        IntercomVideoActivity.this.videoViewOverlay.setBackgroundColor(0);
                        IntercomVideoActivity.this.loadingView.setVisibility(8);
                    }
                }, 200L);
            }
        });
        this.videoView.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            public boolean onError(MediaPlayer mediaPlayer, int what, int extra) {
                IntercomVideoActivity.this.metricTracker.failedToPlayVideo(videoUrl);
                return false;
            }
        });
        this.videoView.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mediaPlayer) {
                IntercomVideoActivity.this.metricTracker.completedVideo();
            }
        });
        this.videoViewOverlay.setOnClickListener((View.OnClickListener)this);
    }

    private void setupToolbar(Provider<AppConfig> appConfigProvider) {
        this.intercomToolbar.setBackgroundColor(appConfigProvider.get().getSecondaryColor());
        this.intercomToolbar.setLeftNavigationItemVisibility(0);
        this.intercomToolbar.setCloseButtonVisibility(8);
        this.intercomToolbar.updateToolbarSize();
        this.wallpaperLoader = WallpaperLoader.create((Context)this, appConfigProvider);
        this.intercomToolbar.loadWallpaper(this.wallpaperLoader);
        this.intercomToolbar.setListener(this);
    }

    @Override
    public void onCloseClicked() {
    }

    @Override
    public void onToolbarClicked() {
    }

    @Override
    public void onInboxClicked() {
        this.closeActivity();
    }

    public void onClick(View v) {
        if (this.mediaController.isShowing()) {
            this.mediaController.hide();
        } else {
            this.mediaController.show();
        }
    }

    private void closeActivity() {
        this.finish();
        this.overridePendingTransition(0, R.anim.intercom_video_slide_out_down);
    }

    private void styleMediaController(View view) {
        int color2 = this.getResources().getColor(R.color.intercom_white);
        if (view instanceof MediaController) {
            MediaController mediaController = (MediaController)view;
            for (int i = 0; i < mediaController.getChildCount(); ++i) {
                this.styleMediaController(mediaController.getChildAt(i));
            }
        } else if (view instanceof LinearLayout) {
            LinearLayout linearLayout = (LinearLayout)view;
            for (int i = 0; i < linearLayout.getChildCount(); ++i) {
                this.styleMediaController(linearLayout.getChildAt(i));
            }
        } else if (view instanceof SeekBar) {
            ((SeekBar)view).getProgressDrawable().mutate().setColorFilter(color2, PorterDuff.Mode.SRC_IN);
            Drawable thumb = ((SeekBar)view).getThumb().mutate();
            thumb.setColorFilter(color2, PorterDuff.Mode.SRC_IN);
        }
    }
}

