/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks.models;

import android.os.Parcel;
import android.os.Parcelable;
import io.intercom.android.sdk.blocks.BlockAlignment;
import io.intercom.android.sdk.blocks.BlockType;
import io.intercom.android.sdk.blocks.models.BlockAttachment;
import java.util.ArrayList;
import java.util.List;

public class Block
implements Parcelable {
    private final List<BlockAttachment> attachments;
    private final List<String> items;
    private final BlockType type;
    private final BlockAlignment align;
    private final String text;
    private final String language;
    private final String url;
    private final String linkUrl;
    private final String embedUrl;
    private final String trackingUrl;
    private final String username;
    private final String provider;
    private final String id;
    private final int width;
    private final int height;
    public static final Parcelable.Creator<Block> CREATOR = new Parcelable.Creator<Block>(){

        public Block createFromParcel(Parcel in) {
            return new Block(in);
        }

        public Block[] newArray(int size) {
            return new Block[size];
        }
    };

    public Block() {
        this(new Builder());
    }

    private Block(Builder builder) {
        this.type = BlockType.typeValueOf(builder.type);
        this.text = builder.text == null ? "" : builder.text;
        this.language = builder.language == null ? "" : builder.language;
        this.url = builder.url == null ? "" : builder.url;
        this.linkUrl = builder.linkUrl == null ? "" : builder.linkUrl;
        this.embedUrl = builder.embedUrl == null ? "" : builder.embedUrl;
        this.trackingUrl = builder.trackingUrl == null ? "" : builder.trackingUrl;
        this.username = builder.username == null ? "" : builder.username;
        this.provider = builder.provider == null ? "" : builder.provider;
        this.id = builder.id == null ? "" : builder.id;
        this.align = BlockAlignment.alignValueOf(builder.align);
        this.width = builder.width;
        this.height = builder.height;
        this.attachments = new ArrayList<BlockAttachment>();
        if (builder.attachments != null) {
            for (Object item : builder.attachments) {
                this.attachments.add((BlockAttachment)(item == null ? new BlockAttachment() : item));
            }
        }
        this.items = new ArrayList<String>();
        if (builder.items != null) {
            for (Object item : builder.items) {
                this.items.add((String)(item == null ? "" : item));
            }
        }
    }

    public BlockType getType() {
        return this.type;
    }

    public String getText() {
        return this.text;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getUrl() {
        return this.url;
    }

    public String getLinkUrl() {
        return this.linkUrl;
    }

    public String getEmbedUrl() {
        return this.embedUrl;
    }

    public String getTrackingUrl() {
        return this.trackingUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getId() {
        return this.id;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public List<String> getItems() {
        return this.items;
    }

    public List<BlockAttachment> getAttachments() {
        return this.attachments;
    }

    public BlockAlignment getAlign() {
        return this.align;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Block block = (Block)o;
        if (this.width != block.width) {
            return false;
        }
        if (this.height != block.height) {
            return false;
        }
        if (this.attachments != null ? !this.attachments.equals(block.attachments) : block.attachments != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(block.items) : block.items != null) {
            return false;
        }
        if (this.type != block.type) {
            return false;
        }
        if (this.align != block.align) {
            return false;
        }
        if (this.text != null ? !this.text.equals(block.text) : block.text != null) {
            return false;
        }
        if (this.language != null ? !this.language.equals(block.language) : block.language != null) {
            return false;
        }
        if (this.url != null ? !this.url.equals(block.url) : block.url != null) {
            return false;
        }
        if (this.linkUrl != null ? !this.linkUrl.equals(block.linkUrl) : block.linkUrl != null) {
            return false;
        }
        if (this.embedUrl != null ? !this.embedUrl.equals(block.embedUrl) : block.embedUrl != null) {
            return false;
        }
        if (this.trackingUrl != null ? !this.trackingUrl.equals(block.trackingUrl) : block.trackingUrl != null) {
            return false;
        }
        if (this.username != null ? !this.username.equals(block.username) : block.username != null) {
            return false;
        }
        if (this.provider != null ? !this.provider.equals(block.provider) : block.provider != null) {
            return false;
        }
        return !(this.id == null ? block.id != null : !this.id.equals(block.id));
    }

    public int hashCode() {
        int result = this.attachments != null ? this.attachments.hashCode() : 0;
        result = 31 * result + (this.items != null ? this.items.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.align != null ? this.align.hashCode() : 0);
        result = 31 * result + (this.text != null ? this.text.hashCode() : 0);
        result = 31 * result + (this.language != null ? this.language.hashCode() : 0);
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.linkUrl != null ? this.linkUrl.hashCode() : 0);
        result = 31 * result + (this.embedUrl != null ? this.embedUrl.hashCode() : 0);
        result = 31 * result + (this.trackingUrl != null ? this.trackingUrl.hashCode() : 0);
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (this.provider != null ? this.provider.hashCode() : 0);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + this.width;
        result = 31 * result + this.height;
        return result;
    }

    public int describeContents() {
        return 0;
    }

    protected Block(Parcel in) {
        this.type = BlockType.typeValueOf(in.readString());
        this.text = in.readString();
        this.language = in.readString();
        this.url = in.readString();
        this.linkUrl = in.readString();
        this.embedUrl = in.readString();
        this.trackingUrl = in.readString();
        this.username = in.readString();
        this.provider = in.readString();
        this.id = in.readString();
        this.width = in.readInt();
        this.height = in.readInt();
        this.align = BlockAlignment.alignValueOf(in.readString());
        this.attachments = new ArrayList<BlockAttachment>();
        if (in.readByte() == 1) {
            in.readList(this.attachments, String.class.getClassLoader());
        }
        this.items = new ArrayList<String>();
        if (in.readByte() == 1) {
            in.readList(this.items, String.class.getClassLoader());
        }
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.type.name());
        dest.writeString(this.text);
        dest.writeString(this.language);
        dest.writeString(this.url);
        dest.writeString(this.linkUrl);
        dest.writeString(this.embedUrl);
        dest.writeString(this.trackingUrl);
        dest.writeString(this.username);
        dest.writeString(this.provider);
        dest.writeString(this.id);
        dest.writeInt(this.width);
        dest.writeInt(this.height);
        dest.writeString(this.align.name());
        if (this.attachments == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeList(this.attachments);
        }
        if (this.items == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeList(this.items);
        }
    }

    public static final class Builder {
        private String type;
        private String text;
        private String language;
        private String url;
        private String linkUrl;
        private String embedUrl;
        private String trackingUrl;
        private String username;
        private String provider;
        private String id;
        private String align;
        private int width;
        private int height;
        private List<BlockAttachment> attachments;
        private List<String> items;

        public Builder withText(String text) {
            this.text = text;
            return this;
        }

        public Builder withType(String type) {
            this.type = type;
            return this;
        }

        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder withAlign(String align) {
            this.align = align;
            return this;
        }

        public Builder withHeight(int height) {
            this.height = height;
            return this;
        }

        public Builder withWidth(int width) {
            this.width = width;
            return this;
        }

        public Builder withAttachments(List<BlockAttachment> attachments) {
            this.attachments = attachments;
            return this;
        }

        public Block build() {
            return new Block(this);
        }
    }
}

