/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.user;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import io.intercom.android.sdk.commons.utilities.DeviceUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class DeviceData {
    private static final String PREFS_DEVICE_ID = "DeviceId";

    public static Map<String, Object> generateDeviceData(Context context) {
        HashMap<String, Object> deviceData = new HashMap<String, Object>();
        deviceData.put("platform_version", Build.VERSION.RELEASE);
        deviceData.put("device", Build.CPU_ABI);
        deviceData.put("platform", Build.MODEL);
        deviceData.put("browser", "Intercom-Android-SDK");
        deviceData.put("version", DeviceData.getAppVersion(context));
        deviceData.put("application", DeviceData.getAppName(context));
        deviceData.put("language", Locale.getDefault().getDisplayLanguage());
        deviceData.put("device_id", DeviceData.getCachedOrNewId(context));
        return deviceData;
    }

    private static String getCachedOrNewId(Context context) {
        SharedPreferences prefs = context.getSharedPreferences("INTERCOM_SDK_DATA", 0);
        String uuid = prefs.getString(PREFS_DEVICE_ID, "");
        if (uuid.isEmpty()) {
            uuid = DeviceUtils.generateDeviceId((Context)context);
            prefs.edit().putString(PREFS_DEVICE_ID, uuid).apply();
        }
        return uuid;
    }

    private static String getAppVersion(Context context) {
        String version = "";
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            version = packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return version;
    }

    private static String getAppName(Context context) {
        String name = "";
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            name = packageInfo.packageName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return name;
    }
}

