/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.spans;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.Layout;
import android.text.Spanned;
import android.text.style.LeadingMarginSpan;
import io.intercom.android.sdk.utilities.ScreenUtils;

public class UnorderedListSpan
implements LeadingMarginSpan {
    private static final int INDENT_IN_DP = 5;
    private static final int BULLET_RADIUS_IN_DP = 2;
    private final int indent;
    private final int bulletRadius;
    private final int gapWidth;

    public UnorderedListSpan(int gapWidth, Context context) {
        this.gapWidth = gapWidth;
        this.bulletRadius = ScreenUtils.convertDpToPixel(2.0f, context);
        this.indent = ScreenUtils.convertDpToPixel(5.0f, context);
    }

    public int getLeadingMargin(boolean first) {
        return 2 * this.bulletRadius + this.gapWidth;
    }

    public void drawLeadingMargin(Canvas c, Paint p, int x, int dir, int top, int baseline, int bottom, CharSequence text, int start, int end, boolean first, Layout l) {
        if (((Spanned)text).getSpanStart((Object)this) == start) {
            Paint.Style style = p.getStyle();
            p.setStyle(Paint.Style.FILL);
            c.drawCircle((float)(x + dir * this.bulletRadius + this.indent), (float)(top + bottom) / 2.0f, (float)this.bulletRadius, p);
            p.setStyle(style);
        }
    }
}

