/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import io.intercom.android.sdk.identity.AppConfig;
import java.util.concurrent.TimeUnit;

public class RateLimiter {
    private final AppConfig appConfig;
    private long periodStartTimestamp;
    private int limitedRequestCount;

    public RateLimiter(AppConfig appConfig) {
        this.appConfig = appConfig;
    }

    public boolean isLimited() {
        return this.isInsideCurrentTimePeriod() && this.hasExceededMaxCount();
    }

    public void increment() {
        if (!this.isInsideCurrentTimePeriod()) {
            this.periodStartTimestamp = System.currentTimeMillis();
            this.limitedRequestCount = 0;
        }
        ++this.limitedRequestCount;
    }

    boolean hasExceededMaxCount() {
        return this.limitedRequestCount >= this.appConfig.getRateLimitCount();
    }

    boolean isInsideCurrentTimePeriod() {
        return System.currentTimeMillis() - this.periodStartTimestamp < TimeUnit.SECONDS.toMillis(this.appConfig.getRateLimitPeriod());
    }

    long getPeriodStartTimestamp() {
        return this.periodStartTimestamp;
    }

    void setPeriodStartTimestamp(long periodStartTimestamp) {
        this.periodStartTimestamp = periodStartTimestamp;
    }

    int getLimitedRequestCount() {
        return this.limitedRequestCount;
    }

    void setLimitedRequestCount(int limitedRequestCount) {
        this.limitedRequestCount = limitedRequestCount;
    }
}

