/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.squareup.okhttp.internal.http;

import io.intercom.com.squareup.okhttp.internal.Util;
import io.intercom.okio.Buffer;
import io.intercom.okio.Sink;
import io.intercom.okio.Timeout;
import java.io.IOException;
import java.net.ProtocolException;

public final class RetryableSink
implements Sink {
    private boolean closed;
    private final int limit;
    private final Buffer content = new Buffer();

    public RetryableSink(int limit) {
        this.limit = limit;
    }

    public RetryableSink() {
        this(-1);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.content.size() < (long)this.limit) {
            throw new ProtocolException("content-length promised " + this.limit + " bytes, but received " + this.content.size());
        }
    }

    @Override
    public void write(Buffer source, long byteCount) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        Util.checkOffsetAndCount(source.size(), 0L, byteCount);
        if (this.limit != -1 && this.content.size() > (long)this.limit - byteCount) {
            throw new ProtocolException("exceeded content-length limit of " + this.limit + " bytes");
        }
        this.content.write(source, byteCount);
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public Timeout timeout() {
        return Timeout.NONE;
    }

    public long contentLength() throws IOException {
        return this.content.size();
    }

    public void writeToSocket(Sink socketOut) throws IOException {
        Buffer buffer = new Buffer();
        this.content.copyTo(buffer, 0L, this.content.size());
        socketOut.write(buffer, buffer.size());
    }
}

