/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.attachments;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.format.Formatter;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.attachments.AttachmentPresenter;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.views.AttachedImageView;
import io.intercom.com.squareup.picasso.Callback;
import io.intercom.com.squareup.picasso.MemoryPolicy;
import io.intercom.com.squareup.picasso.Picasso;
import io.intercom.com.squareup.picasso.RequestCreator;
import java.io.File;

@TargetApi(value=15)
public class AttachmentActivity
extends Activity
implements View.OnClickListener {
    private AttachedImageView previewImage;
    private ImageView attachmentIcon;
    private TextView attachmentDetails;
    private Button sendButton;
    private ProgressBar spinner;
    private AttachmentPresenter presenter;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.intercomsdk_activity_attachment);
        this.spinner = (ProgressBar)this.findViewById(R.id.loading_wheel);
        this.sendButton = (Button)this.findViewById(R.id.send_button);
        this.previewImage = (AttachedImageView)this.findViewById(R.id.image_preview);
        this.attachmentIcon = (ImageView)this.findViewById(R.id.attachment_icon);
        this.attachmentDetails = (TextView)this.findViewById(R.id.attachment_details);
        this.spinner.getIndeterminateDrawable().setColorFilter(this.getResources().getColor(17170443), PorterDuff.Mode.SRC_IN);
        this.sendButton.setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.cancel_button).setOnClickListener((View.OnClickListener)this);
        this.presenter = new AttachmentPresenter(this);
        this.previewImage.setOnAttachedToWindowListener(new AttachedImageView.OnAttachedToWindowListener(){

            @Override
            public void callback() {
                AttachmentActivity.this.presenter.loadFile(AttachmentActivity.this.getIntent().getData(), AttachmentActivity.this.previewImage.isHardwareAccelerated());
            }
        });
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.send_button) {
            this.presenter.sendClicked();
        } else if (id2 == R.id.cancel_button) {
            this.presenter.cancelClicked();
        }
    }

    protected void showDialog(String message) {
        new AlertDialog.Builder((Context)this, 5).setTitle((CharSequence)this.getResources().getString(R.string.intercomsdk_failed_to_send)).setMessage((CharSequence)message).setNegativeButton((CharSequence)this.getResources().getString(R.string.intercomsdk_close), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).show();
    }

    protected void enableSendButton() {
        this.sendButton.setTextColor(this.getResources().getColor(17170443));
        this.sendButton.setEnabled(true);
    }

    protected void displayAttachmentDetails(String fileName, long size, Drawable drawable2) {
        this.attachmentDetails.setText((CharSequence)(fileName + " (" + Formatter.formatFileSize((Context)this, (long)size) + ")"));
        this.attachmentDetails.setVisibility(0);
        this.attachmentIcon.setVisibility(0);
        this.attachmentIcon.setImageDrawable(drawable2);
        this.spinner.setVisibility(8);
    }

    protected void displayFailedAttachment() {
        this.attachmentDetails.setText((CharSequence)this.getResources().getString(R.string.intercomsdk_file_failed));
        this.attachmentDetails.setVisibility(0);
        this.attachmentIcon.setVisibility(0);
        this.attachmentIcon.setImageDrawable(this.getResources().getDrawable(R.drawable.intercomsdk_error));
        this.spinner.setVisibility(8);
    }

    protected void displayImage(File file, int width, int height) {
        RequestCreator requestCreator = Picasso.with((Context)this).load(file);
        if (width > 0 || height > 0) {
            requestCreator.resize(width, height);
        }
        requestCreator.memoryPolicy(MemoryPolicy.NO_CACHE, new MemoryPolicy[0]).into((ImageView)this.previewImage, new Callback(){

            public void onSuccess() {
                IntercomLogger.INTERNAL("images", "SUCCESS");
                AttachmentActivity.this.previewImage.setVisibility(0);
                AttachmentActivity.this.spinner.setVisibility(8);
            }

            public void onError() {
                IntercomLogger.INTERNAL("images", "FAILED");
                AttachmentActivity.this.presenter.imageFailedToLoad();
            }
        });
    }
}

