/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.retrofit.Callback;
import io.intercom.retrofit.RetrofitError;
import io.intercom.retrofit.client.Response;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public abstract class BaseCallback<T>
implements Callback<T> {
    public final void success(T t, Response response) {
        if (t == null) {
            this.failure(RetrofitError.unexpectedError((String)"", (Throwable)new IllegalStateException("no body found")));
        } else {
            this.onSuccess(t);
        }
    }

    public final void failure(RetrofitError error) {
        this.logFailure("Api call failed", error);
        this.onFailure(error);
    }

    abstract void onSuccess(T var1);

    void onFailure(RetrofitError error) {
    }

    void logFailure(String reason, RetrofitError error) {
        IntercomLogger.ERROR(reason + ": " + BaseCallback.getDetails(error));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getDetails(RetrofitError error) {
        String reason = null;
        if (error != null) {
            Response response = error.getResponse();
            if (response != null) {
                if (response.getBody() != null) {
                    String errorBody = "";
                    try {
                        InputStream is = response.getBody().in();
                        BufferedReader bis = new BufferedReader(new InputStreamReader(is));
                        try {
                            String line;
                            StringBuilder stringBuilder = new StringBuilder();
                            while ((line = bis.readLine()) != null) {
                                stringBuilder.append(line);
                            }
                            errorBody = stringBuilder.toString();
                        }
                        finally {
                            is.close();
                            bis.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    reason = " Status: " + response.getStatus() + " Body: " + errorBody;
                } else {
                    reason = response.getReason();
                }
            } else if ("Canceled".equalsIgnoreCase(error.getMessage())) {
                if (!Bridge.getIdentityStore().userIdentityExists()) {
                    reason = "no user currently registered";
                }
                if (!Bridge.getIdentityStore().appIdentityExists()) {
                    reason = "the apiKey or appId used to initialise Intercom are invalid";
                }
            } else {
                reason = error.getMessage();
            }
        }
        if (reason == null) {
            reason = "unknown error";
        }
        return reason;
    }
}

