/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.activities;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentTransaction;
import android.os.Bundle;
import io.intercom.android.sdk.Bridge;
import io.intercom.android.sdk.Inbox.ConversationsListFragment;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.conversation.ConversationFragment;
import io.intercom.android.sdk.conversation.SmallAnnouncementFragment;
import io.intercom.android.sdk.interfaces.OnConversationClickListener;
import io.intercom.android.sdk.interfaces.OnConversationInteractionListener;
import io.intercom.android.sdk.interfaces.OnSmallAnnouncementInteractionListener;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Events.CloseIAMEvent;
import io.intercom.com.squareup.otto.Subscribe;

@TargetApi(value=15)
public class MainActivity
extends Activity
implements OnConversationClickListener,
OnConversationInteractionListener,
OnSmallAnnouncementInteractionListener {
    public static final String OPEN_CONVERSATION = "OpenConversation";
    public static final String SHOW_INBOX = "showInbox";
    private static final String TAG_SMALL_ANNOUNCEMENT = "smallAnnouncementTag";
    private static final String TAG_INBOX = "inboxTag";
    private static final String TAG_CONVERSATION = "conversationTag";
    private final ConversationsListFragment inbox = ConversationsListFragment.getInstance();

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.intercomsdk_activity_main);
        Bridge.init(this.getApplication());
        this.getFragmentManager().executePendingTransactions();
        this.initializeSDK();
        Bridge.getBus().register((Object)this);
    }

    protected void onDestroy() {
        Bridge.getBus().unregister((Object)this);
        super.onDestroy();
    }

    private void initializeSDK() {
        Bundle data = this.getIntent().getExtras();
        Conversation conversation = new Conversation();
        boolean shouldShowInbox = false;
        boolean isRead = false;
        int unreadCount = 0;
        if (data != null) {
            if (data.containsKey("intercomsdk-unreadCount")) {
                unreadCount = data.getInt("intercomsdk-unreadCount");
            }
            if (data.containsKey("intercomsdk-isRead")) {
                isRead = data.getBoolean("intercomsdk-isRead", false);
            }
            if (data.containsKey(OPEN_CONVERSATION)) {
                conversation = (Conversation)data.getParcelable(OPEN_CONVERSATION);
            }
            if (data.containsKey(SHOW_INBOX)) {
                shouldShowInbox = data.getBoolean(SHOW_INBOX);
            }
        }
        this.displaySDK(shouldShowInbox, conversation, unreadCount, isRead);
    }

    private void displaySDK(boolean shouldShowInbox, Conversation conversation, int unreadCount, boolean isRead) {
        if (this.checkIfSmallAnnouncement(conversation)) {
            this.displayFragment(SmallAnnouncementFragment.newInstance(conversation.getId(), conversation.getLastPart()), TAG_SMALL_ANNOUNCEMENT, false);
        } else if (shouldShowInbox) {
            this.displayFragment(this.inbox, TAG_INBOX, false);
        } else {
            this.displayFragment(ConversationFragment.newInstance(conversation.getId(), unreadCount, isRead), TAG_CONVERSATION, false);
        }
    }

    private boolean checkIfSmallAnnouncement(Conversation conversation) {
        return "small-announcement".equals(conversation.getLastPart().getMessageStyle());
    }

    private void displayFragment(Fragment frag, String tag, boolean addToBackStack) {
        IntercomLogger.INTERNAL("frag", "displaying " + frag);
        FragmentTransaction transaction = this.getFragmentManager().beginTransaction();
        transaction.replace(R.id.content_fragment, frag, tag);
        if (addToBackStack) {
            IntercomLogger.INTERNAL("frag", "adding " + frag + " to the back stack");
            transaction.addToBackStack(null);
        }
        transaction.commit();
    }

    public void onBackPressed() {
        IntercomLogger.INTERNAL("frag", "back pressed");
        super.onBackPressed();
    }

    @Override
    public void loadConversation(String conversationId, int unreadCount, boolean isRead) {
        this.displayFragment(ConversationFragment.newInstance(conversationId, unreadCount, isRead), TAG_CONVERSATION, true);
    }

    @Override
    public void loadInbox() {
        if (this.getFragmentManager().findFragmentByTag(TAG_INBOX) != null) {
            this.onBackPressed();
        } else {
            this.displayFragment(this.inbox, TAG_INBOX, false);
        }
    }

    @Override
    public void transitionToConversation(String conversationId) {
        this.displayFragment(ConversationFragment.newInstance(conversationId, 0, true), TAG_CONVERSATION, false);
    }

    @Subscribe
    public void closeSDK(CloseIAMEvent event) {
        this.finish();
    }
}

