/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.retrofit;

import android.os.Build;
import android.os.Process;
import io.intercom.com.google.gson.Gson;
import io.intercom.retrofit.RestAdapter;
import io.intercom.retrofit.Utils;
import io.intercom.retrofit.android.AndroidApacheClient;
import io.intercom.retrofit.android.AndroidLog;
import io.intercom.retrofit.android.MainThreadExecutor;
import io.intercom.retrofit.appengine.UrlFetchClient;
import io.intercom.retrofit.client.Client;
import io.intercom.retrofit.client.OkClient;
import io.intercom.retrofit.client.UrlConnectionClient;
import io.intercom.retrofit.converter.Converter;
import io.intercom.retrofit.converter.GsonConverter;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

abstract class Platform {
    private static final Platform PLATFORM = Platform.findPlatform();
    static final boolean HAS_RX_JAVA = Platform.hasRxJavaOnClasspath();

    Platform() {
    }

    static Platform get() {
        return PLATFORM;
    }

    private static Platform findPlatform() {
        try {
            Class.forName("android.os.Build");
            if (Build.VERSION.SDK_INT != 0) {
                return new Android();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (System.getProperty("com.google.appengine.runtime.version") != null) {
            return new AppEngine();
        }
        return new Base();
    }

    abstract Converter defaultConverter();

    abstract Client.Provider defaultClient();

    abstract Executor defaultHttpExecutor();

    abstract Executor defaultCallbackExecutor();

    abstract RestAdapter.Log defaultLog();

    private static boolean hasOkHttpOnClasspath() {
        try {
            Class.forName("io.intercom.com.squareup.okhttp.OkHttpClient");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static boolean hasRxJavaOnClasspath() {
        try {
            Class.forName("rx.Observable");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static class OkClientInstantiator {
        private OkClientInstantiator() {
        }

        static Client instantiate() {
            return new OkClient();
        }
    }

    private static class AppEngine
    extends Base {
        private AppEngine() {
        }

        @Override
        Client.Provider defaultClient() {
            final UrlFetchClient client = new UrlFetchClient();
            return new Client.Provider(){

                @Override
                public Client get() {
                    return client;
                }
            };
        }
    }

    private static class Android
    extends Platform {
        private Android() {
        }

        @Override
        Converter defaultConverter() {
            return new GsonConverter(new Gson());
        }

        @Override
        Client.Provider defaultClient() {
            final Client client = Platform.hasOkHttpOnClasspath() ? OkClientInstantiator.instantiate() : (Build.VERSION.SDK_INT < 9 ? new AndroidApacheClient() : new UrlConnectionClient());
            return new Client.Provider(){

                @Override
                public Client get() {
                    return client;
                }
            };
        }

        @Override
        Executor defaultHttpExecutor() {
            return Executors.newCachedThreadPool(new ThreadFactory(){

                @Override
                public Thread newThread(final Runnable r) {
                    return new Thread(new Runnable(){

                        @Override
                        public void run() {
                            Process.setThreadPriority((int)10);
                            r.run();
                        }
                    }, "Retrofit-Idle");
                }
            });
        }

        @Override
        Executor defaultCallbackExecutor() {
            return new MainThreadExecutor();
        }

        @Override
        RestAdapter.Log defaultLog() {
            return new AndroidLog("Retrofit");
        }
    }

    private static class Base
    extends Platform {
        private Base() {
        }

        @Override
        Converter defaultConverter() {
            return new GsonConverter(new Gson());
        }

        @Override
        Client.Provider defaultClient() {
            final Client client = Platform.hasOkHttpOnClasspath() ? OkClientInstantiator.instantiate() : new UrlConnectionClient();
            return new Client.Provider(){

                @Override
                public Client get() {
                    return client;
                }
            };
        }

        @Override
        Executor defaultHttpExecutor() {
            return Executors.newCachedThreadPool(new ThreadFactory(){

                @Override
                public Thread newThread(final Runnable r) {
                    return new Thread(new Runnable(){

                        @Override
                        public void run() {
                            Thread.currentThread().setPriority(1);
                            r.run();
                        }
                    }, "Retrofit-Idle");
                }
            });
        }

        @Override
        Executor defaultCallbackExecutor() {
            return new Utils.SynchronousExecutor();
        }

        @Override
        RestAdapter.Log defaultLog() {
            return new RestAdapter.Log(){

                @Override
                public void log(String message) {
                    System.out.println(message);
                }
            };
        }
    }
}

