/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import java.util.UUID;

public class DeviceUtils {
    private static final String PREFS_DEVICE_ID = "DeviceId";

    public static String generateDeviceId(Context context) {
        SharedPreferences prefs = context.getSharedPreferences("INTERCOM_SDK_DATA", 0);
        String uuid = prefs.getString(PREFS_DEVICE_ID, "");
        if (TextUtils.isEmpty((CharSequence)uuid) && TextUtils.isEmpty((CharSequence)(uuid = DeviceUtils.getTelephonyDeviceId(context)))) {
            String macAddress = DeviceUtils.getWifiMacAddress(context);
            String androidId = DeviceUtils.getAndroidId(context);
            if (!TextUtils.isEmpty((CharSequence)macAddress) && TextUtils.isEmpty((CharSequence)androidId)) {
                uuid = new UUID(androidId.hashCode(), macAddress.hashCode()).toString();
            } else if (!TextUtils.isEmpty((CharSequence)androidId)) {
                uuid = androidId;
            }
            if (TextUtils.isEmpty((CharSequence)uuid)) {
                uuid = UUID.randomUUID().toString();
            }
        }
        prefs.edit().putString(PREFS_DEVICE_ID, uuid).apply();
        return uuid;
    }

    private static String getTelephonyDeviceId(Context context) {
        String result = null;
        if (DeviceUtils.checkPermission("android.permission.READ_PHONE_STATE", context)) {
            try {
                TelephonyManager telephonyService = (TelephonyManager)context.getSystemService("phone");
                result = telephonyService.getDeviceId();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result == null ? "" : result;
    }

    private static String getWifiMacAddress(Context context) {
        WifiInfo wifiInfo;
        WifiManager wifiManager;
        String result = null;
        if (DeviceUtils.checkPermission("android.permission.ACCESS_WIFI_STATE", context) && (wifiManager = (WifiManager)context.getSystemService("wifi")) != null && (wifiInfo = wifiManager.getConnectionInfo()) != null) {
            result = wifiInfo.getMacAddress();
        }
        return result == null ? "" : result;
    }

    private static String getAndroidId(Context context) {
        String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        return androidId == null || androidId.equalsIgnoreCase("9774d56d682e549c") ? "" : androidId;
    }

    public static boolean checkPermission(String permissionType, Context context) {
        int res = context.checkCallingOrSelfPermission(permissionType);
        return res == 0;
    }

    public static boolean isMessagingSDKSupported(int androidOsVersion) {
        return androidOsVersion > 14;
    }
}

