/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.logger;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.koin.core.logger.Level;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J!\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\n\u0010\u000b\u001a\u00060\rj\u0002`\fH&\u00a2\u0006\u0002\u0010\u000eJ\u0017\u0010\u000f\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\rj\u0002`\f\u00a2\u0006\u0002\u0010\u0010J\u0017\u0010\u0011\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\rj\u0002`\f\u00a2\u0006\u0002\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\rj\u0002`\f\u00a2\u0006\u0002\u0010\u0010J\u0017\u0010\u0013\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\rj\u0002`\f\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003J\u0016\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\rJ\u001c\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\u0018R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\u0019"}, d2={"Lorg/koin/core/logger/Logger;", "", "level", "Lorg/koin/core/logger/Level;", "<init>", "(Lorg/koin/core/logger/Level;)V", "getLevel", "()Lorg/koin/core/logger/Level;", "setLevel", "display", "", "msg", "Lorg/koin/core/logger/MESSAGE;", "", "(Lorg/koin/core/logger/Level;Ljava/lang/String;)V", "debug", "(Ljava/lang/String;)V", "info", "warn", "error", "isAt", "", "lvl", "log", "Lkotlin/Function0;", "koin-core"})
public abstract class Logger {
    @NotNull
    private Level level;

    public Logger(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        this.level = level;
    }

    public /* synthetic */ Logger(Level level, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            level = Level.INFO;
        }
        this(level);
    }

    @NotNull
    public final Level getLevel() {
        return this.level;
    }

    public final void setLevel(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"<set-?>");
        this.level = level;
    }

    public abstract void display(@NotNull Level var1, @NotNull String var2);

    public final void debug(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.log(Level.DEBUG, msg);
    }

    public final void info(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.log(Level.INFO, msg);
    }

    public final void warn(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.log(Level.WARNING, msg);
    }

    public final void error(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.log(Level.ERROR, msg);
    }

    public final boolean isAt(@NotNull Level lvl) {
        Intrinsics.checkNotNullParameter((Object)((Object)lvl), (String)"lvl");
        return this.level.compareTo((Enum)lvl) <= 0;
    }

    public final void log(@NotNull Level lvl, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)((Object)lvl), (String)"lvl");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (this.isAt(lvl)) {
            this.display(lvl, msg);
        }
    }

    public final void log(@NotNull Level lvl, @NotNull Function0<String> msg) {
        Intrinsics.checkNotNullParameter((Object)((Object)lvl), (String)"lvl");
        Intrinsics.checkNotNullParameter(msg, (String)"msg");
        if (this.isAt(lvl)) {
            this.display(lvl, (String)msg.invoke());
        }
    }

    public Logger() {
        this(null, 1, null);
    }
}

