/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.registry;

import java.io.ByteArrayInputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.error.NoPropertyFileFoundException;
import org.koin.core.logger.Level;
import org.koin.core.logger.Logger;
import org.koin.core.registry.PropertyRegistry;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u001a\u0012\u0010\u0007\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\b\u001a\u00020\u0003\u001a\u0012\u0010\t\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\n\u001a\u00020\u0001\u00a8\u0006\u000b"}, d2={"readDataFromFile", "Ljava/util/Properties;", "content", "", "loadEnvironmentProperties", "", "Lorg/koin/core/registry/PropertyRegistry;", "loadPropertiesFromFile", "fileName", "saveProperties", "properties", "koin-core"})
@SourceDebugExtension(value={"SMAP\nPropertyRegistryExt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropertyRegistryExt.kt\norg/koin/core/registry/PropertyRegistryExtKt\n+ 2 Logger.kt\norg/koin/core/logger/Logger\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,56:1\n28#2:57\n46#2,2:58\n29#2:60\n28#2:63\n46#2,2:64\n29#2:66\n32#2:67\n46#2,2:68\n33#2:70\n28#2:71\n46#2,2:72\n29#2:74\n215#3,2:61\n*S KotlinDebug\n*F\n+ 1 PropertyRegistryExt.kt\norg/koin/core/registry/PropertyRegistryExtKt\n*L\n14#1:57\n14#1:58,2\n14#1:60\n27#1:63\n27#1:64,2\n27#1:66\n31#1:67\n31#1:68,2\n31#1:70\n49#1:71\n49#1:72,2\n49#1:74\n17#1:61,2\n*E\n"})
public final class PropertyRegistryExtKt {
    /*
     * WARNING - void declaration
     */
    public static final void saveProperties(@NotNull PropertyRegistry $this$saveProperties, @NotNull Properties properties) {
        Map propertiesMapValues;
        void this_$iv$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)$this$saveProperties, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Logger logger = $this$saveProperties.get_koin$koin_core().getLogger();
        String msg$iv = "load " + properties.size() + " properties";
        boolean $i$f$debug = false;
        Iterator iterator = this_$iv;
        Level lvl$iv$iv = Level.DEBUG;
        boolean $i$f$log = false;
        if (this_$iv$iv.isAt(lvl$iv$iv)) {
            this_$iv$iv.display(lvl$iv$iv, msg$iv);
        }
        Map map = MapsKt.toMap((Map)properties);
        Intrinsics.checkNotNull((Object)map, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
        Map $this$forEach$iv = propertiesMapValues = map;
        boolean $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String k = (String)entry.getKey();
            String v = (String)entry.getValue();
            $this$saveProperties.saveProperty$koin_core(k, v);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void loadPropertiesFromFile(@NotNull PropertyRegistry $this$loadPropertiesFromFile, @NotNull String fileName) {
        String content;
        String string;
        Charset this_$iv$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)$this$loadPropertiesFromFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Logger logger = $this$loadPropertiesFromFile.get_koin$koin_core().getLogger();
        Object msg$iv = "load properties from " + fileName;
        boolean $i$f$debug2 = false;
        void var5_7 = this_$iv;
        Object lvl$iv$iv = Level.DEBUG;
        boolean $i$f$log = false;
        if (((Logger)((Object)this_$iv$iv)).isAt((Level)((Object)lvl$iv$iv))) {
            ((Logger)((Object)this_$iv$iv)).display((Level)((Object)lvl$iv$iv), (String)msg$iv);
        }
        URL uRL = Koin.class.getResource(fileName);
        if (uRL != null) {
            URL $i$f$debug2 = uRL;
            this_$iv$iv = Charsets.UTF_8;
            lvl$iv$iv = TextStreamsKt.readBytes((URL)$i$f$debug2);
            string = new String((byte[])lvl$iv$iv, this_$iv$iv);
        } else {
            string = content = null;
        }
        if (content != null) {
            void this_$iv$iv2;
            void this_$iv2;
            msg$iv = $this$loadPropertiesFromFile.get_koin$koin_core().getLogger();
            String msg$iv2 = "loaded properties from file:'" + fileName + '\'';
            boolean $i$f$info = false;
            lvl$iv$iv = this_$iv2;
            Level lvl$iv$iv2 = Level.INFO;
            boolean $i$f$log2 = false;
            if (this_$iv$iv2.isAt(lvl$iv$iv2)) {
                this_$iv$iv2.display(lvl$iv$iv2, msg$iv2);
            }
        } else {
            throw new NoPropertyFileFoundException("No properties found for file '" + fileName + '\'');
        }
        Properties properties = PropertyRegistryExtKt.readDataFromFile(content);
        PropertyRegistryExtKt.saveProperties($this$loadPropertiesFromFile, properties);
    }

    private static final Properties readDataFromFile(String content) {
        Properties properties = new Properties();
        String string = content;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        properties.load(new ByteArrayInputStream(byArray));
        return properties;
    }

    /*
     * WARNING - void declaration
     */
    public static final void loadEnvironmentProperties(@NotNull PropertyRegistry $this$loadEnvironmentProperties) {
        void this_$iv$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)$this$loadEnvironmentProperties, (String)"<this>");
        Logger logger = $this$loadEnvironmentProperties.get_koin$koin_core().getLogger();
        String msg$iv = "load properties from environment";
        boolean $i$f$debug = false;
        Properties properties = this_$iv;
        Level lvl$iv$iv = Level.DEBUG;
        boolean $i$f$log = false;
        if (this_$iv$iv.isAt(lvl$iv$iv)) {
            this_$iv$iv.display(lvl$iv$iv, msg$iv);
        }
        Properties sysProperties = System.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)sysProperties, (String)"sysProperties");
        PropertyRegistryExtKt.saveProperties($this$loadEnvironmentProperties, sysProperties);
        Map<String, String> map = System.getenv();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getenv()");
        Map<String, String> map2 = map;
        Properties properties2 = properties = new Properties();
        properties2.putAll(map2);
        Properties sysEnvProperties = properties;
        PropertyRegistryExtKt.saveProperties($this$loadEnvironmentProperties, sysEnvProperties);
    }
}

