/*
 * Decompiled with CFR 0.152.
 */
package org.koin.core.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.annotation.KoinInternalApi;
import org.koin.core.definition.BeanDefinition;
import org.koin.core.definition.BeanDefinitionKt;
import org.koin.core.definition.Kind;
import org.koin.core.instance.InstanceContext;
import org.koin.core.instance.InstanceFactory;
import org.koin.core.instance.ScopedInstanceFactory;
import org.koin.core.instance.SingleInstanceFactory;
import org.koin.core.logger.Level;
import org.koin.core.module.Module;
import org.koin.core.module.ModuleKt;
import org.koin.core.parameter.ParametersHolder;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012J(\u0010\u0013\u001a\u00020\u00112\u001e\u0010\u0014\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00160\u0015j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0016`\u0017H\u0002JP\u0010\u0018\u001a\u00020\u0011\"\u0006\b\u0000\u0010\u0019\u0018\u00012\u0006\u0010\u001a\u001a\u0002H\u00192\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0012\b\u0002\u0010\u001d\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001f0\u001e2\b\b\u0002\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001cH\u0081\b\u00a2\u0006\u0002\u0010#J\u0015\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020&H\u0000\u00a2\u0006\u0002\b'J-\u0010(\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001e\"\u0004\b\u0000\u0010\u00192\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010*\u001a\u00020+H\u0000\u00a2\u0006\u0002\b,J\u0018\u0010-\u001a\u00020\u00112\u0006\u0010.\u001a\u00020/2\u0006\u0010 \u001a\u00020!H\u0002J#\u00100\u001a\u00020\u00112\f\u00101\u001a\b\u0012\u0004\u0012\u00020/0\u001e2\u0006\u0010 \u001a\u00020!H\u0000\u00a2\u0006\u0002\b2J=\u00103\u001a\u0004\u0018\u0001H\u0019\"\u0004\b\u0000\u0010\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030\u001f2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010*\u001a\u00020+H\u0000\u00a2\u0006\u0004\b4\u00105J2\u00106\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!2\n\u00107\u001a\u00060\u0007j\u0002`\b2\n\u00108\u001a\u0006\u0012\u0002\b\u00030\t2\b\b\u0002\u00109\u001a\u00020!H\u0007J\u0006\u0010:\u001a\u00020;J\u0010\u0010<\u001a\u00020\u00112\u0006\u0010.\u001a\u00020/H\u0002J\u001b\u0010=\u001a\u00020\u00112\f\u00101\u001a\b\u0012\u0004\u0012\u00020/0\u001eH\u0000\u00a2\u0006\u0002\b>R\"\u0010\u0005\u001a\u0016\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR%\u0010\f\u001a\u0016\u0012\b\u0012\u00060\u0007j\u0002`\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006?"}, d2={"Lorg/koin/core/registry/InstanceRegistry;", "", "_koin", "Lorg/koin/core/Koin;", "(Lorg/koin/core/Koin;)V", "_instances", "", "", "Lorg/koin/core/definition/IndexKey;", "Lorg/koin/core/instance/InstanceFactory;", "get_koin", "()Lorg/koin/core/Koin;", "instances", "", "getInstances", "()Ljava/util/Map;", "close", "", "close$koin_core", "createEagerInstances", "eagerInstances", "Ljava/util/HashSet;", "Lorg/koin/core/instance/SingleInstanceFactory;", "Lkotlin/collections/HashSet;", "declareInstance", "T", "instance", "qualifier", "Lorg/koin/core/qualifier/Qualifier;", "secondaryTypes", "", "Lkotlin/reflect/KClass;", "allowOverride", "", "scopeQualifier", "(Ljava/lang/Object;Lorg/koin/core/qualifier/Qualifier;Ljava/util/List;ZLorg/koin/core/qualifier/Qualifier;)V", "dropScopeInstances", "scope", "Lorg/koin/core/scope/Scope;", "dropScopeInstances$koin_core", "getAll", "clazz", "instanceContext", "Lorg/koin/core/instance/InstanceContext;", "getAll$koin_core", "loadModule", "module", "Lorg/koin/core/module/Module;", "loadModules", "modules", "loadModules$koin_core", "resolveInstance", "resolveInstance$koin_core", "(Lorg/koin/core/qualifier/Qualifier;Lkotlin/reflect/KClass;Lorg/koin/core/qualifier/Qualifier;Lorg/koin/core/instance/InstanceContext;)Ljava/lang/Object;", "saveMapping", "mapping", "factory", "logWarning", "size", "", "unloadModule", "unloadModules", "unloadModules$koin_core", "koin-core"})
public final class InstanceRegistry {
    @NotNull
    private final Koin _koin;
    @NotNull
    private final Map<String, InstanceFactory<?>> _instances;

    public InstanceRegistry(@NotNull Koin _koin) {
        Intrinsics.checkNotNullParameter((Object)_koin, (String)"_koin");
        this._koin = _koin;
        this._instances = KoinPlatformTools.INSTANCE.safeHashMap();
    }

    @NotNull
    public final Koin get_koin() {
        return this._koin;
    }

    @NotNull
    public final Map<String, InstanceFactory<?>> getInstances() {
        return this._instances;
    }

    public final void loadModules$koin_core(@NotNull List<Module> modules2, boolean allowOverride) {
        Intrinsics.checkNotNullParameter(modules2, (String)"modules");
        Iterable $this$forEach$iv = modules2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Module module = (Module)element$iv;
            boolean bl = false;
            this.loadModule(module, allowOverride);
            this.createEagerInstances(module.getEagerInstances());
        }
    }

    private final void loadModule(Module module, boolean allowOverride) {
        Map $this$forEach$iv = module.getMappings();
        boolean $i$f$forEach = false;
        Map map = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$mapping$factory = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$mapping$factory;
            boolean bl3 = false;
            String mapping = (String)entry.getKey();
            Map.Entry entry2 = $dstr$mapping$factory;
            boolean bl4 = false;
            InstanceFactory factory2 = (InstanceFactory)entry2.getValue();
            InstanceRegistry.saveMapping$default(this, allowOverride, mapping, factory2, false, 8, null);
        }
    }

    @KoinInternalApi
    public final void saveMapping(boolean allowOverride, @NotNull String mapping, @NotNull InstanceFactory<?> factory2, boolean logWarning) {
        Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
        Intrinsics.checkNotNullParameter(factory2, (String)"factory");
        if (this._instances.containsKey(mapping)) {
            if (!allowOverride) {
                ModuleKt.overrideError(factory2, mapping);
            } else if (logWarning) {
                this._koin.getLogger().info("Warning - override mapping: " + mapping + " defintion:" + factory2.getBeanDefinition());
            }
        }
        if (this._koin.getLogger().isAt(Level.DEBUG) && logWarning) {
            this._koin.getLogger().debug("add mapping '" + mapping + "' for " + factory2.getBeanDefinition());
        }
        Map<String, InstanceFactory<?>> map = this._instances;
        boolean bl = false;
        map.put(mapping, factory2);
    }

    public static /* synthetic */ void saveMapping$default(InstanceRegistry instanceRegistry, boolean bl, String string, InstanceFactory instanceFactory, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            bl2 = true;
        }
        instanceRegistry.saveMapping(bl, string, instanceFactory, bl2);
    }

    private final void createEagerInstances(HashSet<SingleInstanceFactory<?>> eagerInstances) {
        if (this._koin.getLogger().isAt(Level.DEBUG)) {
            this._koin.getLogger().debug("Creating eager instances ...");
        }
        InstanceContext defaultContext = new InstanceContext(this._koin, this._koin.getScopeRegistry().getRootScope(), null, 4, null);
        Iterable $this$forEach$iv = eagerInstances;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SingleInstanceFactory factory2 = (SingleInstanceFactory)element$iv;
            boolean bl = false;
            factory2.get(defaultContext);
        }
    }

    @Nullable
    public final <T> T resolveInstance$koin_core(@Nullable Qualifier qualifier, @NotNull KClass<?> clazz, @NotNull Qualifier scopeQualifier, @NotNull InstanceContext instanceContext) {
        T t;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)scopeQualifier, (String)"scopeQualifier");
        Intrinsics.checkNotNullParameter((Object)instanceContext, (String)"instanceContext");
        String indexKey = BeanDefinitionKt.indexKey(clazz, qualifier, scopeQualifier);
        InstanceFactory<?> instanceFactory = this._instances.get(indexKey);
        T t2 = t = instanceFactory == null ? null : (T)instanceFactory.get(instanceContext);
        if (t == null) {
            // empty if block
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    @PublishedApi
    public final /* synthetic */ <T> void declareInstance(T instance, Qualifier qualifier, List<? extends KClass<?>> secondaryTypes, boolean allowOverride, Qualifier scopeQualifier) {
        void kind$iv;
        Intrinsics.checkNotNullParameter(secondaryTypes, (String)"secondaryTypes");
        Intrinsics.checkNotNullParameter((Object)scopeQualifier, (String)"scopeQualifier");
        boolean $i$f$declareInstance = false;
        Kind kind = Kind.Scoped;
        Intrinsics.needClassReification();
        Function2 definition$iv = new Function2<Scope, ParametersHolder, T>(instance){
            final /* synthetic */ T $instance;
            {
                this.$instance = $instance;
                super(2);
            }

            public final T invoke(@NotNull Scope $this$createDefinition, @NotNull ParametersHolder it) {
                Intrinsics.checkNotNullParameter((Object)$this$createDefinition, (String)"$this$createDefinition");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$instance;
            }
        };
        boolean $i$f$createDefinition = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        BeanDefinition def2 = new BeanDefinition(scopeQualifier, Reflection.getOrCreateKotlinClass(Object.class), qualifier, definition$iv, (Kind)kind$iv, secondaryTypes);
        ScopedInstanceFactory factory2 = new ScopedInstanceFactory(def2);
        String indexKey = BeanDefinitionKt.indexKey(def2.getPrimaryType(), def2.getQualifier(), def2.getScopeQualifier());
        InstanceRegistry.saveMapping$default(this, allowOverride, indexKey, factory2, false, 8, null);
        Iterable $this$forEach$iv = def2.getSecondaryTypes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KClass clazz = (KClass)element$iv;
            boolean bl = false;
            String index = BeanDefinitionKt.indexKey(clazz, def2.getQualifier(), def2.getScopeQualifier());
            InstanceRegistry.saveMapping$default(this, allowOverride, index, factory2, false, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ void declareInstance$default(InstanceRegistry this_, Object instance, Qualifier qualifier, List secondaryTypes, boolean allowOverride, Qualifier scopeQualifier, int n, Object object) {
        void kind$iv;
        if ((n & 2) != 0) {
            qualifier = null;
        }
        if ((n & 4) != 0) {
            secondaryTypes = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            allowOverride = true;
        }
        Intrinsics.checkNotNullParameter((Object)secondaryTypes, (String)"secondaryTypes");
        Intrinsics.checkNotNullParameter((Object)scopeQualifier, (String)"scopeQualifier");
        boolean $i$f$declareInstance = false;
        Kind kind = Kind.Scoped;
        Intrinsics.needClassReification();
        Function2 definition$iv = new /* invalid duplicate definition of identical inner class */;
        boolean $i$f$createDefinition = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        BeanDefinition def2 = new BeanDefinition(scopeQualifier, Reflection.getOrCreateKotlinClass(Object.class), qualifier, definition$iv, (Kind)kind$iv, secondaryTypes);
        ScopedInstanceFactory factory2 = new ScopedInstanceFactory(def2);
        String indexKey = BeanDefinitionKt.indexKey(def2.getPrimaryType(), def2.getQualifier(), def2.getScopeQualifier());
        InstanceRegistry.saveMapping$default(this_, allowOverride, indexKey, factory2, false, 8, null);
        Iterable $this$forEach$iv = def2.getSecondaryTypes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KClass clazz = (KClass)element$iv;
            boolean bl = false;
            String index = BeanDefinitionKt.indexKey(clazz, def2.getQualifier(), def2.getScopeQualifier());
            InstanceRegistry.saveMapping$default(this_, allowOverride, index, factory2, false, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void dropScopeInstances$koin_core(@NotNull Scope scope) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Iterable $this$filterIsInstance$iv = this._instances.values();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ScopedInstanceFactory)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScopedInstanceFactory factory2 = (ScopedInstanceFactory)element$iv;
            boolean bl = false;
            factory2.drop(scope);
        }
    }

    public final void close$koin_core() {
        Map<String, InstanceFactory<?>> $this$forEach$iv = this._instances;
        boolean $i$f$forEach = false;
        Map<String, InstanceFactory<?>> map = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, InstanceFactory<?>>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, InstanceFactory<?>> element$iv;
            Map.Entry<String, InstanceFactory<?>> $dstr$key$factory = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry<String, InstanceFactory<?>> entry = $dstr$key$factory;
            boolean bl3 = false;
            String key = entry.getKey();
            Map.Entry<String, InstanceFactory<?>> entry2 = $dstr$key$factory;
            boolean bl4 = false;
            InstanceFactory<?> factory2 = entry2.getValue();
            factory2.dropAll();
        }
        this._instances.clear();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> List<T> getAll$koin_core(@NotNull KClass<?> clazz, @NotNull InstanceContext instanceContext) {
        void $this$mapTo$iv$iv;
        InstanceFactory factory2;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)instanceContext, (String)"instanceContext");
        Iterable $this$filter$iv = this._instances.values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            factory2 = (InstanceFactory)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)factory2.getBeanDefinition().getScopeQualifier(), (Object)instanceContext.getScope().getScopeQualifier())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            factory2 = (InstanceFactory)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual(factory2.getBeanDefinition().getPrimaryType(), clazz) || factory2.getBeanDefinition().getSecondaryTypes().contains(clazz))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            factory2 = (InstanceFactory)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object t = it.get(instanceContext);
            collection.add(t);
        }
        return (List)destination$iv$iv;
    }

    public final void unloadModules$koin_core(@NotNull List<Module> modules2) {
        Intrinsics.checkNotNullParameter(modules2, (String)"modules");
        Iterable $this$forEach$iv = modules2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Module it = (Module)element$iv;
            boolean bl = false;
            this.unloadModule(it);
        }
    }

    private final void unloadModule(Module module) {
        Set<String> set = module.getMappings().keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"module.mappings.keys");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String mapping = (String)element$iv;
            boolean bl = false;
            if (!this._instances.containsKey(mapping)) continue;
            InstanceFactory<?> instanceFactory = this._instances.get(mapping);
            if (instanceFactory != null) {
                instanceFactory.dropAll();
            }
            this._instances.remove(mapping);
        }
    }

    public final int size() {
        return this._instances.size();
    }
}

