/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.money;

import io.hypersistence.utils.hibernate.type.ImmutableCompositeType;
import io.hypersistence.utils.hibernate.type.util.Configuration;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.money.MonetaryAmount;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.javamoney.moneta.Money;

public class MonetaryAmountType
extends ImmutableCompositeType<MonetaryAmount> {
    public static final MonetaryAmountType INSTANCE = new MonetaryAmountType();

    public MonetaryAmountType() {
        super(MonetaryAmount.class);
    }

    public MonetaryAmountType(Configuration configuration) {
        super(MonetaryAmount.class, configuration);
    }

    public String[] getPropertyNames() {
        return new String[]{"amount", "currency"};
    }

    public Type[] getPropertyTypes() {
        return new Type[]{BigDecimalType.INSTANCE, StringType.INSTANCE};
    }

    public Object getPropertyValue(Object component, int property) throws HibernateException {
        MonetaryAmount monetaryAmount = (MonetaryAmount)component;
        if (property == 0) {
            return monetaryAmount.getNumber().numberValue(BigDecimal.class);
        }
        if (property == 1) {
            return monetaryAmount.getCurrency();
        }
        throw new IllegalArgumentException("Invalid property index " + property + " for class " + component.getClass());
    }

    public void setPropertyValue(Object component, int property, Object value) throws HibernateException {
        throw new HibernateException("Call setPropertyValue on immutable type " + component.getClass());
    }

    @Override
    protected MonetaryAmount get(ResultSet rs, String[] names, SharedSessionContractImplementor session, Object owner) throws SQLException {
        String amountColumnName = names[0];
        String currencyColumnName = names[1];
        BigDecimal amount = rs.getBigDecimal(amountColumnName);
        if (amount == null) {
            return null;
        }
        String currency = rs.getString(currencyColumnName);
        if (currency == null) {
            return null;
        }
        return Money.of((BigDecimal)amount, (String)currency);
    }

    @Override
    protected void set(PreparedStatement st, MonetaryAmount value, int amountColumnIndex, SharedSessionContractImplementor session) throws SQLException {
        int currencyColumnIndex = amountColumnIndex + 1;
        if (value == null) {
            st.setNull(amountColumnIndex, 3);
            st.setNull(currencyColumnIndex, 12);
        } else {
            BigDecimal amount = (BigDecimal)value.getNumber().numberValue(BigDecimal.class);
            String currency = value.getCurrency().getCurrencyCode();
            st.setBigDecimal(amountColumnIndex, amount);
            st.setString(currencyColumnIndex, currency);
        }
    }

    public int getPropertyIndex(String propertyName) {
        switch (propertyName) {
            case "amount": {
                return 0;
            }
            case "property": {
                return 1;
            }
        }
        throw new IllegalArgumentException("Unknown property name: " + propertyName);
    }
}

