/*
 * Decompiled with CFR 0.152.
 */
package io.huannguyen.swipetodeleterv;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.helper.ItemTouchHelper;
import android.util.AttributeSet;
import android.view.View;
import io.huannguyen.swipetodeleterv.R;
import io.huannguyen.swipetodeleterv.STDAdapter;
import io.huannguyen.swipetodeleterv.utils.ResourceUtils;

public class STDRecyclerView
extends RecyclerView {
    @DrawableRes
    private int mDeleteIconRes;
    @ColorInt
    private int mBorderColor;
    private float mBorderWidth;
    @ColorInt
    private int mLTRDeleteViewBackground;
    @ColorInt
    private int mRTLDeleteViewBackground;
    private String mLTRInfoText;
    private String mRTLInfoText;
    private float mDeleteIconHeight;
    private float mDeleteIconWidth;
    private float mLeftDeleteIconMargin;
    private float mRightDeleteIconMargin;
    private String mDeleteMessage;
    private boolean mHasBorder;
    @ColorInt
    private int mDeleteIconColor;
    private Paint mPaint = new Paint();
    private Bitmap mDeleteIcon;
    private Rect textBound = new Rect();

    public STDRecyclerView(Context context) {
        super(context);
    }

    public STDRecyclerView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.processAttributes(context, attrs, 0);
    }

    public STDRecyclerView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.processAttributes(context, attrs, defStyle);
    }

    private void processAttributes(Context context, AttributeSet attrs, int defStyle) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.stdrv, defStyle, 0);
        this.mDeleteIconRes = typedArray.getResourceId(R.styleable.stdrv_delete_icon, R.drawable.ic_delete);
        this.mBorderColor = typedArray.getColor(R.styleable.stdrv_border_color, ResourceUtils.getColor(context, R.color.stdrv_default_border_color));
        this.mBorderWidth = typedArray.getDimension(R.styleable.stdrv_border_width, ResourceUtils.getDimension(context, R.dimen.stdrv_default_border_width));
        this.mLTRDeleteViewBackground = typedArray.getColor(R.styleable.stdrv_ltr_delete_view_background, ResourceUtils.getColor(context, R.color.stdrv_default_delete_view_background));
        this.mRTLDeleteViewBackground = typedArray.getColor(R.styleable.stdrv_rtl_delete_view_background, ResourceUtils.getColor(context, R.color.stdrv_default_delete_view_background));
        this.mDeleteIconHeight = typedArray.getDimension(R.styleable.stdrv_delete_icon_height, ResourceUtils.getDimension(context, R.dimen.stdrv_default_icon_size));
        this.mDeleteIconWidth = typedArray.getDimension(R.styleable.stdrv_delete_icon_width, ResourceUtils.getDimension(context, R.dimen.stdrv_default_icon_size));
        this.mLeftDeleteIconMargin = typedArray.getDimension(R.styleable.stdrv_left_delete_icon_margin, ResourceUtils.getDimension(context, R.dimen.stdrv_default_icon_margin));
        this.mRightDeleteIconMargin = typedArray.getDimension(R.styleable.stdrv_right_delete_icon_margin, ResourceUtils.getDimension(context, R.dimen.stdrv_default_icon_margin));
        this.mDeleteMessage = typedArray.getString(R.styleable.stdrv_delete_message);
        this.mHasBorder = typedArray.getBoolean(R.styleable.stdrv_has_border, true);
        this.mDeleteIconColor = typedArray.getColor(R.styleable.stdrv_delete_icon_color, -1);
        this.mLTRInfoText = typedArray.getString(R.styleable.stdrv_ltr_info_text);
        this.mRTLInfoText = typedArray.getString(R.styleable.stdrv_rtl_info_text);
        typedArray.recycle();
        this.initResources();
    }

    private void initResources() {
        this.mDeleteIcon = BitmapFactory.decodeResource((Resources)this.getResources(), (int)this.mDeleteIconRes);
        if (this.mDeleteIconColor != -1) {
            this.mDeleteIcon = ResourceUtils.changeBitmapColor(this.mDeleteIcon, this.mDeleteIconColor);
        }
        this.mPaint.setTextSize(ResourceUtils.getDimension(this.getContext(), R.dimen.stdrv_default_text_size));
        this.mPaint.setTypeface(Typeface.create((Typeface)Typeface.DEFAULT, (int)1));
    }

    public void setupSwipeToDelete(final STDAdapter adapter, int swipeDirection) {
        this.setAdapter(adapter);
        ItemTouchHelper.SimpleCallback callback = new ItemTouchHelper.SimpleCallback(0, swipeDirection){

            public boolean onMove(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, RecyclerView.ViewHolder target) {
                return false;
            }

            public int getSwipeDirs(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
                int dirs = adapter.getSwipeDirs(viewHolder);
                if (dirs == -1) {
                    return super.getSwipeDirs(recyclerView, viewHolder);
                }
                return dirs;
            }

            public void onSwiped(RecyclerView.ViewHolder viewHolder, int direction) {
                adapter.onItemCleared(viewHolder, STDRecyclerView.this);
            }

            public void onChildDraw(Canvas c, RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
                super.onChildDraw(c, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
                if (actionState == 1) {
                    View itemView = viewHolder.itemView;
                    float height = itemView.getBottom() - itemView.getTop();
                    if (dX != 0.0f) {
                        boolean hasBackground;
                        float iconWidth = STDRecyclerView.this.mDeleteIconWidth;
                        boolean bl = hasBackground = itemView.getBackground() != null;
                        if (dX > 0.0f) {
                            STDRecyclerView.this.mPaint.setColor(STDRecyclerView.this.mLTRDeleteViewBackground);
                            c.drawRect((float)itemView.getLeft(), (float)itemView.getTop(), dX, (float)itemView.getBottom(), STDRecyclerView.this.mPaint);
                            if (dX > STDRecyclerView.this.mLeftDeleteIconMargin) {
                                if (!hasBackground && dX < STDRecyclerView.this.mLeftDeleteIconMargin + STDRecyclerView.this.mDeleteIconWidth) {
                                    iconWidth = (int)(dX - STDRecyclerView.this.mLeftDeleteIconMargin);
                                    Rect iconDrawnPortion = new Rect(0, 0, (int)iconWidth, (int)STDRecyclerView.this.mDeleteIconHeight);
                                    RectF deleteIconPos = new RectF((float)(itemView.getLeft() + (int)STDRecyclerView.this.mLeftDeleteIconMargin), (float)((int)((double)itemView.getTop() + 0.5 * (double)(height - STDRecyclerView.this.mDeleteIconHeight))), (float)((int)((float)itemView.getLeft() + STDRecyclerView.this.mLeftDeleteIconMargin + iconWidth)), (float)((int)((double)itemView.getBottom() - 0.5 * (double)(height - STDRecyclerView.this.mDeleteIconHeight))));
                                    c.drawBitmap(STDRecyclerView.this.mDeleteIcon, iconDrawnPortion, deleteIconPos, STDRecyclerView.this.mPaint);
                                } else {
                                    c.drawBitmap(STDRecyclerView.this.mDeleteIcon, (float)(itemView.getLeft() + (int)STDRecyclerView.this.mLeftDeleteIconMargin), (float)((int)((double)itemView.getTop() + 0.5 * (double)(height - STDRecyclerView.this.mDeleteIconHeight))), STDRecyclerView.this.mPaint);
                                    STDRecyclerView.this.mPaint.setColor(-16777216);
                                    STDRecyclerView.this.mPaint.getTextBounds(STDRecyclerView.this.mLTRInfoText, 0, 1, STDRecyclerView.this.textBound);
                                    c.drawText(STDRecyclerView.this.mLTRInfoText, 0, STDRecyclerView.this.mLTRInfoText.length(), (float)itemView.getLeft() + iconWidth + STDRecyclerView.this.mLeftDeleteIconMargin + 20.0f, (float)itemView.getTop() + (height + (float)STDRecyclerView.this.textBound.height()) / 2.0f, STDRecyclerView.this.mPaint);
                                }
                            }
                        } else {
                            STDRecyclerView.this.mPaint.setColor(STDRecyclerView.this.mRTLDeleteViewBackground);
                            c.drawRect((float)itemView.getRight() + dX, (float)itemView.getTop(), (float)itemView.getRight(), (float)itemView.getBottom(), STDRecyclerView.this.mPaint);
                            if (dX < 0.0f - STDRecyclerView.this.mRightDeleteIconMargin) {
                                if (!hasBackground && dX > 0.0f - STDRecyclerView.this.mLeftDeleteIconMargin - STDRecyclerView.this.mDeleteIconWidth) {
                                    iconWidth = (int)(0.0f - dX - STDRecyclerView.this.mRightDeleteIconMargin);
                                    Rect iconDrawnPortion = new Rect((int)(STDRecyclerView.this.mDeleteIconWidth - iconWidth), 0, (int)STDRecyclerView.this.mDeleteIconWidth, (int)STDRecyclerView.this.mDeleteIconHeight);
                                    RectF deleteIconPos = new RectF((float)itemView.getRight() - STDRecyclerView.this.mRightDeleteIconMargin - iconWidth, (float)((double)itemView.getTop() + 0.5 * (double)(height - STDRecyclerView.this.mDeleteIconHeight)), (float)itemView.getRight() - STDRecyclerView.this.mRightDeleteIconMargin, (float)((double)itemView.getBottom() - 0.5 * (double)(height - STDRecyclerView.this.mDeleteIconHeight)));
                                    c.drawBitmap(STDRecyclerView.this.mDeleteIcon, iconDrawnPortion, deleteIconPos, STDRecyclerView.this.mPaint);
                                } else {
                                    c.drawBitmap(STDRecyclerView.this.mDeleteIcon, (float)itemView.getRight() - STDRecyclerView.this.mRightDeleteIconMargin - iconWidth, (float)((double)itemView.getTop() + 0.5 * (double)(height - STDRecyclerView.this.mDeleteIconHeight)), STDRecyclerView.this.mPaint);
                                    STDRecyclerView.this.mPaint.setColor(-16777216);
                                    STDRecyclerView.this.mPaint.getTextBounds(STDRecyclerView.this.mRTLInfoText, 0, STDRecyclerView.this.mRTLInfoText.length(), STDRecyclerView.this.textBound);
                                    c.drawText(STDRecyclerView.this.mRTLInfoText, 0, STDRecyclerView.this.mRTLInfoText.length(), (float)(itemView.getRight() - STDRecyclerView.this.textBound.width()) - iconWidth - STDRecyclerView.this.mRightDeleteIconMargin - 20.0f, (float)itemView.getTop() + (height + (float)STDRecyclerView.this.textBound.height()) / 2.0f, STDRecyclerView.this.mPaint);
                                }
                            }
                        }
                    }
                }
            }

            public void onChildDrawOver(Canvas c, RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
                if (actionState == 1 && dX != 0.0f && STDRecyclerView.this.mHasBorder) {
                    View itemView = viewHolder.itemView;
                    STDRecyclerView.this.mPaint.setColor(STDRecyclerView.this.mBorderColor);
                    c.drawRect((float)itemView.getLeft(), (float)itemView.getTop(), (float)itemView.getRight(), (float)itemView.getTop() + STDRecyclerView.this.mBorderWidth, STDRecyclerView.this.mPaint);
                    c.drawRect((float)itemView.getLeft(), (float)itemView.getBottom() - STDRecyclerView.this.mBorderWidth, (float)itemView.getRight(), (float)itemView.getBottom(), STDRecyclerView.this.mPaint);
                }
                super.onChildDrawOver(c, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
            }
        };
        ItemTouchHelper touchHelper = new ItemTouchHelper((ItemTouchHelper.Callback)callback);
        touchHelper.attachToRecyclerView((RecyclerView)this);
    }

    @DrawableRes
    public int getDeleteIconRes() {
        return this.mDeleteIconRes;
    }

    public void setDeleteIconRes(@DrawableRes int deleteIconRes) {
        this.mDeleteIconRes = deleteIconRes;
    }

    public int getBorderColor() {
        return this.mBorderColor;
    }

    public void setBorderColor(int borderColor) {
        this.mBorderColor = borderColor;
    }

    public float getBorderWidth() {
        return this.mBorderWidth;
    }

    public void setBorderWidth(float borderWidth) {
        this.mBorderWidth = borderWidth;
    }

    public int getLTRDeleteViewBackground() {
        return this.mLTRDeleteViewBackground;
    }

    public void setLTRDeleteViewBackground(int LTRDeleteViewBackground) {
        this.mLTRDeleteViewBackground = LTRDeleteViewBackground;
    }

    public int getRTLDeleteViewBackground() {
        return this.mRTLDeleteViewBackground;
    }

    public void setRTLDeleteViewBackground(int RTLDeleteViewBackground) {
        this.mRTLDeleteViewBackground = RTLDeleteViewBackground;
    }

    public float getDeleteIconHeight() {
        return this.mDeleteIconHeight;
    }

    public void setDeleteIconHeight(float deleteIconHeight) {
        this.mDeleteIconHeight = deleteIconHeight;
    }

    public float getDeleteIconWidth() {
        return this.mDeleteIconWidth;
    }

    public void setDeleteIconWidth(float deleteIconWidth) {
        this.mDeleteIconWidth = deleteIconWidth;
    }

    public float getLeftDeleteIconMargin() {
        return this.mLeftDeleteIconMargin;
    }

    public void setLeftDeleteIconMargin(float leftDeleteIconMargin) {
        this.mLeftDeleteIconMargin = leftDeleteIconMargin;
    }

    public float getRightDeleteIconMargin() {
        return this.mRightDeleteIconMargin;
    }

    public void setRightDeleteIconMargin(float rightDeleteIconMargin) {
        this.mRightDeleteIconMargin = rightDeleteIconMargin;
    }

    public String getDeleteMessage() {
        return this.mDeleteMessage;
    }

    public void setDeleteMessage(String deleteMessage) {
        this.mDeleteMessage = deleteMessage;
    }

    public boolean isHasBorder() {
        return this.mHasBorder;
    }

    public void setHasBorder(boolean hasBorder) {
        this.mHasBorder = hasBorder;
    }

    public int getDeleteIconColor() {
        return this.mDeleteIconColor;
    }

    public void setDeleteIconColor(int deleteIconColor) {
        this.mDeleteIconColor = deleteIconColor;
    }

    public Bitmap getDeleteIcon() {
        return this.mDeleteIcon;
    }

    public void setDeleteIcon(Bitmap deleteIcon) {
        this.mDeleteIcon = deleteIcon;
    }

    public String getRTLInfoText() {
        return this.mRTLInfoText;
    }

    public void setRTLInfoText(String RTLInfoText) {
        this.mRTLInfoText = RTLInfoText;
    }

    public String getLTRInfoText() {
        return this.mLTRInfoText;
    }

    public void setLTRInfoText(String LTRInfoText) {
        this.mLTRInfoText = LTRInfoText;
    }
}

