/*
 * Decompiled with CFR 0.152.
 */
package io.huannguyen.swipetodeleterv;

import android.support.design.widget.Snackbar;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import io.huannguyen.swipetodeleterv.ItemRemovalListener;
import io.huannguyen.swipetodeleterv.R;
import io.huannguyen.swipetodeleterv.STDRecyclerView;
import java.util.List;

public abstract class STDAdapter<T>
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    protected List<T> mItems;
    protected ItemRemovalListener<T> mItemRemovalListener;

    protected STDAdapter(List<T> items) {
        this.mItems = items;
    }

    public void onItemCleared(RecyclerView.ViewHolder viewHolder, STDRecyclerView recyclerView) {
        final int adapterPosition = viewHolder.getAdapterPosition();
        final T item = this.mItems.get(adapterPosition);
        final Snackbar snackbar = Snackbar.make((View)recyclerView, (CharSequence)this.getDeleteMessage(viewHolder, recyclerView), (int)0).setAction(R.string.stdrv_action_undo, new View.OnClickListener(){

            public void onClick(View v) {
                STDAdapter.this.mItems.add(adapterPosition, item);
                STDAdapter.this.notifyItemInserted(adapterPosition);
                if (STDAdapter.this.mItemRemovalListener != null) {
                    STDAdapter.this.mItemRemovalListener.onItemAddedBack(adapterPosition);
                }
            }
        });
        snackbar.setCallback(new Snackbar.Callback(){

            public void onDismissed(Snackbar snackbar, int event) {
                if (event != 1 && STDAdapter.this.mItemRemovalListener != null) {
                    STDAdapter.this.mItemRemovalListener.onItemPermanentlyRemoved(item);
                }
            }
        });
        snackbar.show();
        snackbar.getView().setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                snackbar.dismiss();
            }
        });
        if (this.mItemRemovalListener != null) {
            this.mItemRemovalListener.onItemTemporarilyRemoved(adapterPosition);
        }
        this.mItems.remove(adapterPosition);
        this.notifyItemRemoved(adapterPosition);
    }

    protected String getDeleteMessage(RecyclerView.ViewHolder viewHolder, STDRecyclerView recyclerView) {
        return recyclerView.getDeleteMessage();
    }

    protected int getSwipeDirs(RecyclerView.ViewHolder viewHolder) {
        return -1;
    }

    public ItemRemovalListener getItemRemovalListener() {
        return this.mItemRemovalListener;
    }

    public void setItemRemovalListener(ItemRemovalListener itemRemovalListener) {
        this.mItemRemovalListener = itemRemovalListener;
    }
}

