/*
 * Decompiled with CFR 0.152.
 */
package io.huannguyen.swipetodeleterv;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.helper.ItemTouchHelper;
import android.util.AttributeSet;
import android.view.View;
import io.huannguyen.swipetodeleterv.ItemRemovalListener;
import io.huannguyen.swipetodeleterv.R;
import io.huannguyen.swipetodeleterv.STDAdapter;
import io.huannguyen.swipetodeleterv.utils.ResourceUtils;

public class STDRecyclerView
extends RecyclerView {
    protected ItemRemovalListener mItemRemovalListener;
    @DrawableRes
    private int mDeleteIconRes;
    @ColorInt
    private int mBorderColor;
    private float mBorderWidth;
    @ColorInt
    private int mDeleteViewBackground;
    private float mDeleteIconHeight;
    private float mDeleteIconWidth;
    private float mLeftDeleteIconMargin;
    private float mRightDeleteIconMargin;
    private String mDeleteMessage;
    private boolean mHasBorder;
    private Paint mPaint = new Paint();

    public STDRecyclerView(Context context) {
        super(context);
    }

    public STDRecyclerView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.processAttributes(context, attrs, 0);
    }

    public STDRecyclerView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.processAttributes(context, attrs, defStyle);
    }

    private void processAttributes(Context context, AttributeSet attrs, int defStyle) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.stdrv, defStyle, 0);
        this.mDeleteIconRes = typedArray.getResourceId(R.styleable.stdrv_delete_icon, R.drawable.ic_delete);
        this.mBorderColor = typedArray.getColor(R.styleable.stdrv_border_color, ResourceUtils.getColor(context, R.color.stdrv_default_border_color));
        this.mBorderWidth = typedArray.getDimension(R.styleable.stdrv_border_width, ResourceUtils.getDimension(context, R.dimen.stdrv_default_border_width));
        this.mDeleteViewBackground = typedArray.getColor(R.styleable.stdrv_delete_view_background, ResourceUtils.getColor(context, R.color.stdrv_default_delete_view_background));
        this.mDeleteIconHeight = typedArray.getDimension(R.styleable.stdrv_delete_icon_height, ResourceUtils.getDimension(context, R.dimen.stdrv_default_icon_size));
        this.mDeleteIconWidth = typedArray.getDimension(R.styleable.stdrv_delete_icon_width, ResourceUtils.getDimension(context, R.dimen.stdrv_default_icon_size));
        this.mLeftDeleteIconMargin = typedArray.getDimension(R.styleable.stdrv_left_delete_icon_margin, ResourceUtils.getDimension(context, R.dimen.stdrv_default_icon_margin));
        this.mRightDeleteIconMargin = typedArray.getDimension(R.styleable.stdrv_right_delete_icon_margin, ResourceUtils.getDimension(context, R.dimen.stdrv_default_icon_margin));
        this.mDeleteMessage = typedArray.getString(R.styleable.stdrv_delete_message);
        this.mHasBorder = typedArray.getBoolean(R.styleable.stdrv_has_border, true);
        typedArray.recycle();
    }

    protected int getSwipeDirs(RecyclerView.ViewHolder viewHolder) {
        return -1;
    }

    public void setupSwipeToDelete(final STDAdapter adapter, int swipeDirection) {
        this.setAdapter(adapter);
        ItemTouchHelper.SimpleCallback callback = new ItemTouchHelper.SimpleCallback(0, swipeDirection){

            public boolean onMove(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, RecyclerView.ViewHolder target) {
                return false;
            }

            public int getSwipeDirs(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
                int dirs = ((STDRecyclerView)recyclerView).getSwipeDirs(viewHolder);
                if (dirs == -1) {
                    return super.getSwipeDirs(recyclerView, viewHolder);
                }
                return dirs;
            }

            public void onSwiped(RecyclerView.ViewHolder viewHolder, int direction) {
                adapter.onItemCleared(viewHolder, STDRecyclerView.this);
            }

            public void onChildDraw(Canvas c, RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
                if (actionState == 1) {
                    View itemView = viewHolder.itemView;
                    float height = itemView.getBottom() - itemView.getTop();
                    if (dX != 0.0f) {
                        RectF background;
                        Bitmap deleteIcon = BitmapFactory.decodeResource((Resources)STDRecyclerView.this.getResources(), (int)STDRecyclerView.this.mDeleteIconRes);
                        Rect iconDrawnPortion = null;
                        float iconWidth = STDRecyclerView.this.mDeleteIconWidth;
                        STDRecyclerView.this.mPaint.setColor(STDRecyclerView.this.mDeleteViewBackground);
                        if (dX > 0.0f) {
                            background = new RectF((float)itemView.getLeft(), (float)itemView.getTop(), dX, (float)itemView.getBottom());
                            c.drawRect(background, STDRecyclerView.this.mPaint);
                            if (dX > STDRecyclerView.this.mLeftDeleteIconMargin) {
                                if (dX < STDRecyclerView.this.mLeftDeleteIconMargin + STDRecyclerView.this.mDeleteIconWidth) {
                                    iconWidth = (int)(dX - STDRecyclerView.this.mLeftDeleteIconMargin);
                                    iconDrawnPortion = new Rect(0, 0, (int)iconWidth, (int)STDRecyclerView.this.mDeleteIconHeight);
                                }
                                RectF deleteIconPos = new RectF((float)(itemView.getLeft() + (int)STDRecyclerView.this.mLeftDeleteIconMargin), (float)((int)((double)itemView.getTop() + 0.5 * (double)(height - STDRecyclerView.this.mDeleteIconHeight))), (float)((int)((float)itemView.getLeft() + STDRecyclerView.this.mLeftDeleteIconMargin + iconWidth)), (float)((int)((double)itemView.getBottom() - 0.5 * (double)(height - STDRecyclerView.this.mDeleteIconHeight))));
                                c.drawBitmap(deleteIcon, iconDrawnPortion, deleteIconPos, STDRecyclerView.this.mPaint);
                            }
                        } else {
                            background = new RectF((float)itemView.getRight() + dX, (float)itemView.getTop(), (float)itemView.getRight(), (float)itemView.getBottom());
                            c.drawRect(background, STDRecyclerView.this.mPaint);
                            if (dX < 0.0f - STDRecyclerView.this.mRightDeleteIconMargin) {
                                if (dX > 0.0f - STDRecyclerView.this.mLeftDeleteIconMargin - STDRecyclerView.this.mDeleteIconWidth) {
                                    iconWidth = (int)(0.0f - dX - STDRecyclerView.this.mRightDeleteIconMargin);
                                    iconDrawnPortion = new Rect((int)(STDRecyclerView.this.mDeleteIconWidth - iconWidth), 0, (int)STDRecyclerView.this.mDeleteIconWidth, (int)STDRecyclerView.this.mDeleteIconHeight);
                                }
                                RectF deleteIconPos = new RectF((float)itemView.getRight() - STDRecyclerView.this.mRightDeleteIconMargin - iconWidth, (float)((double)itemView.getTop() + 0.5 * (double)(height - STDRecyclerView.this.mDeleteIconHeight)), (float)itemView.getRight() - STDRecyclerView.this.mRightDeleteIconMargin, (float)((double)itemView.getBottom() - 0.5 * (double)(height - STDRecyclerView.this.mDeleteIconHeight)));
                                c.drawBitmap(deleteIcon, iconDrawnPortion, deleteIconPos, STDRecyclerView.this.mPaint);
                            }
                        }
                        if (STDRecyclerView.this.mHasBorder) {
                            STDRecyclerView.this.mPaint.setColor(STDRecyclerView.this.mBorderColor);
                            RectF topBorder = new RectF((float)itemView.getLeft(), (float)itemView.getTop(), (float)itemView.getRight(), (float)itemView.getTop() + STDRecyclerView.this.mBorderWidth);
                            c.drawRect(topBorder, STDRecyclerView.this.mPaint);
                            RectF bottomBorder = new RectF((float)itemView.getLeft(), (float)itemView.getBottom() - STDRecyclerView.this.mBorderWidth, (float)itemView.getRight(), (float)itemView.getBottom());
                            c.drawRect(bottomBorder, STDRecyclerView.this.mPaint);
                        }
                    }
                }
                super.onChildDraw(c, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
            }
        };
        ItemTouchHelper touchHelper = new ItemTouchHelper((ItemTouchHelper.Callback)callback);
        touchHelper.attachToRecyclerView((RecyclerView)this);
    }

    public ItemRemovalListener getItemRemovalListener() {
        return this.mItemRemovalListener;
    }

    public void setItemRemovalListener(ItemRemovalListener itemRemovalListener) {
        this.mItemRemovalListener = itemRemovalListener;
    }

    @DrawableRes
    public int getDeleteIconRes() {
        return this.mDeleteIconRes;
    }

    public void setDeleteIconRes(@DrawableRes int deleteIconRes) {
        this.mDeleteIconRes = deleteIconRes;
    }

    public int getBorderColor() {
        return this.mBorderColor;
    }

    public void setBorderColor(int borderColor) {
        this.mBorderColor = borderColor;
    }

    public float getBorderWidth() {
        return this.mBorderWidth;
    }

    public void setBorderWidth(float borderWidth) {
        this.mBorderWidth = borderWidth;
    }

    public int getDeleteViewBackground() {
        return this.mDeleteViewBackground;
    }

    public void setDeleteViewBackground(int deleteViewBackground) {
        this.mDeleteViewBackground = deleteViewBackground;
    }

    public float getDeleteIconHeight() {
        return this.mDeleteIconHeight;
    }

    public void setDeleteIconHeight(float deleteIconHeight) {
        this.mDeleteIconHeight = deleteIconHeight;
    }

    public float getDeleteIconWidth() {
        return this.mDeleteIconWidth;
    }

    public void setDeleteIconWidth(float deleteIconWidth) {
        this.mDeleteIconWidth = deleteIconWidth;
    }

    public float getLeftDeleteIconMargin() {
        return this.mLeftDeleteIconMargin;
    }

    public void setLeftDeleteIconMargin(float leftDeleteIconMargin) {
        this.mLeftDeleteIconMargin = leftDeleteIconMargin;
    }

    public float getRightDeleteIconMargin() {
        return this.mRightDeleteIconMargin;
    }

    public void setRightDeleteIconMargin(float rightDeleteIconMargin) {
        this.mRightDeleteIconMargin = rightDeleteIconMargin;
    }

    public String getDeleteMessage() {
        return this.mDeleteMessage;
    }

    public void setDeleteMessage(String deleteMessage) {
        this.mDeleteMessage = deleteMessage;
    }

    public boolean isHasBorder() {
        return this.mHasBorder;
    }

    public void setHasBorder(boolean hasBorder) {
        this.mHasBorder = hasBorder;
    }
}

