/*
 * Decompiled with CFR 0.152.
 */
package heretical.pointer.path;

import heretical.pointer.path.Pointer;
import heretical.pointer.path.PointerCompiler;
import heretical.pointer.path.Resolver;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;

class WildCardResolver<Node, Result>
extends Resolver<Node, Result> {
    public WildCardResolver(PointerCompiler<Node, Result> compiler) {
        super(compiler);
    }

    @Override
    boolean isWildCard() {
        return true;
    }

    @Override
    Result resolve(Resolver<Node, Result> previous, Node node, Result result) {
        this.compiler.iterable(node).forEach(child -> this.next.resolve(this, child, result));
        return result;
    }

    @Override
    Result remove(Resolver<Node, Result> previous, Node parent, Pointer<Node> pointer, Node node) {
        Object result = this.compiler.resultNode();
        switch (this.compiler.kind(node)) {
            case Array: {
                int i = 0;
                for (Node child : this.compiler.iterable(node)) {
                    Pointer current = this.next.isFinal() ? this.get(i) : null;
                    Object removed = this.next.remove(this, node, current, child);
                    this.compiler.addAll(result, removed);
                    ++i;
                }
                break;
            }
            case Map: {
                Iterator<Map.Entry<String, Node>> fields = this.compiler.entries(node);
                while (fields.hasNext()) {
                    Map.Entry<String, Node> next = fields.next();
                    Pointer current = this.next.isFinal() ? this.get(next.getKey()) : null;
                    Object removed = this.next.remove(this, node, current, next.getValue());
                    this.compiler.addAll(result, removed);
                }
                break;
            }
        }
        return result;
    }

    @Override
    public void set(Resolver<Node, Result> previous, Node parent, Pointer<Node> pointer, Node node, Function<Node, Node> transform) {
        switch (this.compiler.kind(node)) {
            case Array: {
                int i = 0;
                for (Node child : this.compiler.iterable(node)) {
                    Pointer current = this.next.isFinal() ? this.get(i) : null;
                    this.next.set(this, node, current, child, transform);
                    ++i;
                }
                break;
            }
            case Map: {
                Iterator<Map.Entry<String, Node>> fields = this.compiler.entries(node);
                while (fields.hasNext()) {
                    Map.Entry<String, Node> next = fields.next();
                    Pointer current = this.next.isFinal() ? this.get(next.getKey()) : null;
                    this.next.set(this, node, current, next.getValue(), transform);
                }
                break;
            }
        }
    }

    @Override
    public void copy(Resolver<Node, Result> previous, Deque<String> queue, Node root, Node from, Pointer<Node> pointer, Node into, Predicate<Node> filter) {
        switch (this.compiler.kind(from)) {
            case Array: {
                int i = 0;
                for (Node child : this.compiler.iterable(from)) {
                    Pointer current = this.next.isFinal() ? this.get(i) : null;
                    queue.addLast("/" + i);
                    this.next.copy(this, queue, root, child, current, into, filter);
                    queue.removeLast();
                    ++i;
                }
                break;
            }
            case Map: {
                Iterator<Map.Entry<String, Node>> fields = this.compiler.entries(from);
                while (fields.hasNext()) {
                    Map.Entry<String, Node> next = fields.next();
                    Pointer current = this.next.isFinal() ? this.get(next.getKey()) : null;
                    queue.addLast("/" + next.getKey());
                    this.next.copy(this, queue, root, next.getValue(), current, into, filter);
                    queue.removeLast();
                }
                break;
            }
        }
    }
}

