/*
 * Decompiled with CFR 0.152.
 */
package heretical.pointer.path;

import heretical.pointer.path.Pointer;
import heretical.pointer.path.PointerCompiler;
import heretical.pointer.path.Resolver;
import java.util.Deque;
import java.util.function.Function;
import java.util.function.Predicate;

class PointerResolver<Node, Result>
extends Resolver<Node, Result> {
    final Pointer<Node> pointer;

    public PointerResolver(PointerCompiler<Node, Result> compiler, String pointer) {
        super(compiler);
        this.pointer = compiler.compile(pointer);
    }

    @Override
    Result resolve(Resolver<Node, Result> previous, Node node, Result result) {
        Node at = this.pointer.at(node);
        if (at == null) {
            return result;
        }
        this.next.resolve(this, at, result);
        return result;
    }

    @Override
    Result remove(Resolver<Node, Result> previous, Node parent, Pointer<Node> pointer, Node node) {
        Node child = this.pointer.at(node);
        if (child == null) {
            return null;
        }
        return this.next.remove(this, node, this.pointer, child);
    }

    @Override
    public void set(Resolver<Node, Result> previous, Node parent, Pointer<Node> pointer, Node node, Function<Node, Node> transform) {
        Node child = this.pointer.at(node);
        if (child == null) {
            return;
        }
        this.next.set(this, node, this.pointer, child, transform);
    }

    @Override
    public void copy(Resolver<Node, Result> previous, Deque<String> queue, Node root, Node from, Pointer<Node> pointer, Node into, Predicate<Node> filter) {
        Node child = this.pointer.at(from);
        if (child == null) {
            return;
        }
        queue.addLast(this.pointer.toString());
        this.next.copy(this, queue, root, child, this.pointer, into, filter);
        queue.removeLast();
    }
}

