/*
 * Decompiled with CFR 0.152.
 */
package heretical.pointer.operation;

import heretical.pointer.operation.CopySpec;
import heretical.pointer.operation.CopySpecDecorator;
import heretical.pointer.path.NestedPointerCompiler;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;

public class Copier<Node, Result>
implements Serializable {
    private final NestedPointerCompiler<Node, Result> nestedPointerCompiler;
    private final CopySpecDecorator<Node>[] copySpecs;

    public Copier(NestedPointerCompiler<Node, Result> nestedPointerCompiler, CopySpec ... copySpecs) {
        this.nestedPointerCompiler = nestedPointerCompiler;
        this.copySpecs = CopySpecDecorator.array(this.nestedPointerCompiler, copySpecs);
        this.verify();
    }

    protected void verify() {
        for (CopySpecDecorator<Node> copySpec : this.copySpecs) {
            copySpec.verify();
        }
    }

    protected CopySpecDecorator<Node>[] getCopySpecs() {
        return this.copySpecs;
    }

    public void copy(Map<Comparable, Object> arguments, Node fromNode, Node resultNode) {
        this.resetTransforms(arguments);
        this.copy(fromNode, resultNode);
    }

    public void copy(Node fromNode, Node resultNode) {
        for (CopySpecDecorator<Node> copySpec : this.copySpecs) {
            Object intoNode = copySpec.getIntoPointer().objectAt(resultNode);
            for (CopySpecDecorator.FromDecorator fromSpec : copySpec.getFromSpecs()) {
                Object fromResult = fromSpec.getFromPointer().allAt(fromNode);
                Iterable<Node> iterable = this.iterable(fromResult);
                for (Object fromValue : iterable) {
                    fromSpec.getIncludePointers().forEach((pointer, filter) -> pointer.copy(fromValue, intoNode, filter));
                    fromSpec.getExcludePointers().forEach(pointer -> pointer.remove(intoNode));
                    fromSpec.getTransformPointers().forEach((pointer, transform) -> pointer.apply(intoNode, transform));
                }
            }
        }
    }

    public void resetTransforms(Map<Comparable, Object> arguments) {
        if (arguments == null) {
            arguments = Collections.emptyMap();
        }
        for (CopySpecDecorator<Node> copySpec : this.copySpecs) {
            copySpec.resetTransforms(arguments);
        }
    }

    protected Iterable<Node> iterable(Result node) {
        return this.nestedPointerCompiler.iterable(node);
    }
}

