/*
 * Decompiled with CFR 0.152.
 */
package heretical.pointer.operation;

import heretical.pointer.operation.BuildSpec;
import heretical.pointer.path.NestedPointerCompiler;
import heretical.pointer.path.Pointer;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;

class BuildSpecDecorator<Node>
implements Serializable {
    private final BuildSpec<?> buildSpec;
    private final NestedPointerCompiler<Node, ?> compiler;
    private transient Pointer<Node> intoPointer;
    private transient List<LiteralDecorator> literalList;
    private transient List<CopyDecorator> copyList;

    public static <Node> BuildSpecDecorator<Node>[] array(NestedPointerCompiler<Node, ?> compiler, BuildSpec ... buildSpecs) {
        BuildSpecDecorator[] results = new BuildSpecDecorator[buildSpecs.length];
        for (int i = 0; i < buildSpecs.length; ++i) {
            results[i] = new BuildSpecDecorator<Node>(buildSpecs[i], compiler);
        }
        return results;
    }

    public BuildSpecDecorator(BuildSpec buildSpec, NestedPointerCompiler<Node, ?> compiler) {
        this.buildSpec = buildSpec;
        this.compiler = compiler;
    }

    public void verify() {
        try {
            this.getIntoPointer();
            this.getLiteralList();
            this.getCopyList();
        }
        catch (RuntimeException exception) {
            throw new IllegalArgumentException("BuildSpec has invalid pointer: " + this.toString(), exception);
        }
    }

    public List<LiteralDecorator> getLiteralList() {
        if (this.literalList != null) {
            return this.literalList;
        }
        this.literalList = this.buildSpec.getLiteralList().stream().map(x$0 -> new LiteralDecorator((BuildSpec.Literal)x$0)).collect(Collectors.toList());
        return this.literalList;
    }

    public List<CopyDecorator> getCopyList() {
        if (this.copyList != null) {
            return this.copyList;
        }
        this.copyList = this.buildSpec.putList.stream().map(x$0 -> new CopyDecorator((BuildSpec.Put)x$0)).collect(Collectors.toList());
        return this.copyList;
    }

    public Pointer<Node> getIntoPointer() {
        if (this.intoPointer == null) {
            this.intoPointer = this.compiler.compile(this.buildSpec.getInto());
        }
        return this.intoPointer;
    }

    public class CopyDecorator {
        private final BuildSpec.Put put;
        private transient Pointer<Node> intoPointer;

        public CopyDecorator(BuildSpec.Put put) {
            this.put = put;
        }

        public BuildSpec.Op getMode() {
            return this.put.getOp();
        }

        public Comparable getFromKey() {
            return this.put.getFromKey();
        }

        public Type getAsType() {
            return this.put.getAsType();
        }

        public Pointer<Node> getIntoPointer() {
            if (this.intoPointer == null) {
                this.intoPointer = BuildSpecDecorator.this.compiler.compile(this.put.getInto());
            }
            return this.intoPointer;
        }

        public String toString() {
            return this.put.toString();
        }
    }

    public class LiteralDecorator {
        private final BuildSpec.Literal literal;
        private transient Pointer<Node> intoPointer;

        public LiteralDecorator(BuildSpec.Literal literal) {
            this.literal = literal;
        }

        public Object getValue() {
            return this.literal.getValue();
        }

        public Pointer<Node> getIntoPointer() {
            if (this.intoPointer == null) {
                this.intoPointer = BuildSpecDecorator.this.compiler.compile(this.literal.getInto());
            }
            return this.intoPointer;
        }

        public String toString() {
            return this.literal.toString();
        }
    }
}

