/*
 * Decompiled with CFR 0.152.
 */
package heretical.pointer.operation;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;

public class BuildSpec<T extends BuildSpec>
implements Serializable {
    private static final String ROOT = "";
    String into = "";
    Type defaultType = String.class;
    List<Literal> literalList = new LinkedList<Literal>();
    List<Put> putList = new LinkedList<Put>();

    public BuildSpec() {
    }

    protected T self() {
        return (T)this;
    }

    public BuildSpec(Type defaultType) {
        this.defaultType = defaultType;
    }

    public BuildSpec(String intoPointer) {
        this.into = intoPointer;
    }

    public BuildSpec(String intoPointer, Type defaultType) {
        this.into = intoPointer;
        this.defaultType = defaultType;
    }

    public String getInto() {
        return this.into;
    }

    public T withDefaultType(Type defaultType) {
        this.defaultType = defaultType;
        return this.self();
    }

    protected List<Literal> getLiteralList() {
        return this.literalList;
    }

    protected List<Put> getPutList() {
        return this.putList;
    }

    public T putInto(Object value, String intoPointer) {
        this.literalList.add(new Literal(value, intoPointer));
        return this.self();
    }

    public T putInto(String from, String intoPointer) {
        this.putList.add(new Put(Op.put, (Comparable)((Object)from), this.defaultType, intoPointer));
        return this.self();
    }

    public T putInto(String from, Type asType, String intoPointer) {
        this.putList.add(new Put(Op.put, (Comparable)((Object)from), asType, intoPointer));
        return this.self();
    }

    public T putInto(Comparable from, String intoPointer) {
        this.putList.add(new Put(Op.put, from, this.defaultType, intoPointer));
        return this.self();
    }

    public T putInto(Comparable from, Type asType, String intoPointer) {
        this.putList.add(new Put(Op.put, from, asType, intoPointer));
        return this.self();
    }

    public T addInto(String from, String intoPointer) {
        this.putList.add(new Put(Op.add, (Comparable)((Object)from), this.defaultType, intoPointer));
        return this.self();
    }

    public T addInto(String from, Type asType, String intoPointer) {
        this.putList.add(new Put(Op.add, (Comparable)((Object)from), asType, intoPointer));
        return this.self();
    }

    public T addInto(Comparable from, String intoPointer) {
        this.putList.add(new Put(Op.add, from, this.defaultType, intoPointer));
        return this.self();
    }

    public T addInto(Comparable from, Type asType, String intoPointer) {
        this.putList.add(new Put(Op.add, from, asType, intoPointer));
        return this.self();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BuildSpec{");
        sb.append("into='").append(this.into).append('\'');
        sb.append(", defaultType=").append(this.defaultType);
        sb.append(", literalList=").append(this.literalList);
        sb.append(", putList=").append(this.putList);
        sb.append('}');
        return sb.toString();
    }

    protected class Put
    implements Serializable {
        final Op op;
        final Comparable from;
        final Type asType;
        final String into;

        public Put(Op op, Comparable from, Type asType, String into) {
            this.op = op;
            this.from = from;
            this.asType = asType;
            this.into = into;
        }

        public Op getOp() {
            return this.op;
        }

        public Comparable getFromKey() {
            return this.from;
        }

        public Type getAsType() {
            return this.asType;
        }

        public String getInto() {
            return this.into;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Copy{");
            sb.append("op=").append((Object)this.op);
            sb.append(", from='").append(this.from).append('\'');
            sb.append(", asType=").append(this.asType);
            sb.append(", into='").append(this.into).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }

    protected static class Literal
    implements Serializable {
        final Object value;
        final String into;

        protected Literal(Object value, String into) {
            this.value = value;
            this.into = into;
        }

        public Object getValue() {
            return this.value;
        }

        public String getInto() {
            return this.into;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Literal{");
            sb.append("value=").append(this.value);
            sb.append(", into='").append(this.into).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }

    static enum Op {
        put,
        add;

    }
}

