/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.websocket;

import io.helidon.common.LazyValue;
import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.DataReader;
import io.helidon.common.socket.SocketContext;
import io.helidon.websocket.AbstractWsFrame;
import io.helidon.websocket.WsCloseException;
import io.helidon.websocket.WsOpCode;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Random;

public final class ClientWsFrame
extends AbstractWsFrame {
    private static final System.Logger LOGGER = System.getLogger(ClientWsFrame.class.getName());
    private static final LazyValue<Random> RANDOM = LazyValue.create(SecureRandom::new);
    private final LazyValue<BufferData> masked;
    private final int[] mask;

    private ClientWsFrame(WsOpCode opCode, long payloadLength, BufferData data, boolean fin, int[] mask, boolean masked, boolean isPayload) {
        super(ClientWsFrame.unmaskedValue(masked, data, mask), payloadLength, fin, isPayload, opCode);
        this.mask = mask;
        this.masked = masked ? LazyValue.create((Object)data) : LazyValue.create(() -> ClientWsFrame.mask(data, mask));
    }

    public static ClientWsFrame data(String text, boolean last) {
        BufferData bufferData = BufferData.create((byte[])text.getBytes(StandardCharsets.UTF_8));
        return new ClientWsFrame(WsOpCode.TEXT, bufferData.available(), bufferData, last, ClientWsFrame.newMaskingKey(), false, true);
    }

    public static ClientWsFrame data(BufferData bufferData, boolean last) {
        return new ClientWsFrame(WsOpCode.BINARY, bufferData.available(), bufferData, last, ClientWsFrame.newMaskingKey(), false, true);
    }

    public static ClientWsFrame control(WsOpCode opCode, BufferData bufferData) {
        return new ClientWsFrame(opCode, bufferData.available(), bufferData, true, ClientWsFrame.newMaskingKey(), false, false);
    }

    public static ClientWsFrame read(SocketContext ctx, DataReader dataReader, int maxFrameLength) {
        AbstractWsFrame.FrameHeader header = ClientWsFrame.readFrameHeader(dataReader, maxFrameLength);
        if (!header.masked()) {
            throw new WsCloseException("Unmasked client frame", 1002);
        }
        int[] maskingKey = new int[]{dataReader.read(), dataReader.read(), dataReader.read(), dataReader.read()};
        BufferData payload = ClientWsFrame.readPayload(dataReader, header);
        ClientWsFrame frame = new ClientWsFrame(header.opCode(), header.length(), payload, header.fin(), maskingKey, true, ClientWsFrame.isPayload(header));
        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
            ctx.log(LOGGER, System.Logger.Level.TRACE, "ws client frame recv %s", new Object[]{frame});
        }
        return frame;
    }

    @Override
    public boolean masked() {
        return true;
    }

    @Override
    public int[] maskingKey() {
        return this.mask;
    }

    public BufferData maskedData() {
        return (BufferData)this.masked.get();
    }

    private static LazyValue<BufferData> unmaskedValue(boolean masked, BufferData data, int[] mask) {
        if (masked) {
            return LazyValue.create(() -> ClientWsFrame.unmask(data, mask));
        }
        return LazyValue.create((Object)data);
    }

    private static int[] newMaskingKey() {
        Random random = (Random)RANDOM.get();
        int[] maskingKey = new int[4];
        for (int i = 0; i < maskingKey.length; ++i) {
            maskingKey[i] = random.nextInt(256);
        }
        return maskingKey;
    }

    private static BufferData unmask(BufferData data, int[] masks) {
        int length = data.available();
        BufferData unmasked = BufferData.create((int)length);
        for (int i = 0; i < length; ++i) {
            int maskIndex = i % 4;
            int mask = masks[maskIndex];
            unmasked.write(data.read() ^ mask);
        }
        return unmasked;
    }

    private static BufferData mask(BufferData data, int[] masks) {
        int length = data.available();
        BufferData unmasked = BufferData.create((int)length);
        for (int i = 0; i < length; ++i) {
            int maskIndex = i % 4;
            int mask = masks[maskIndex];
            unmasked.write(data.read() ^ mask);
        }
        return unmasked;
    }
}

