/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.testing.junit5;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.config.GlobalConfig;
import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.common.testing.virtualthreads.PinningRecorder;
import io.helidon.webserver.ListenerConfig;
import io.helidon.webserver.Router;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.WebServerConfig;
import io.helidon.webserver.testing.junit5.Junit5Util;
import io.helidon.webserver.testing.junit5.JunitExtensionBase;
import io.helidon.webserver.testing.junit5.ServerTest;
import io.helidon.webserver.testing.junit5.SetUpRoute;
import io.helidon.webserver.testing.junit5.spi.ServerJunitExtension;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

class HelidonServerJunitExtension
extends JunitExtensionBase
implements BeforeAllCallback,
AfterAllCallback,
AfterEachCallback,
ParameterResolver {
    private final Map<String, URI> uris = new ConcurrentHashMap<String, URI>();
    private final List<ServerJunitExtension> extensions = HelidonServiceLoader.create(ServiceLoader.load(ServerJunitExtension.class)).asList();
    private WebServer server;
    private PinningRecorder pinningRecorder;

    HelidonServerJunitExtension() {
    }

    public void beforeAll(ExtensionContext context) {
        super.beforeAll(context);
        this.run(context, () -> {
            if (System.getProperty("helidon.config.profile") == null && System.getProperty("config.profile") == null) {
                System.setProperty("helidon.config.profile", "test");
            }
            Class testClass = context.getRequiredTestClass();
            super.testClass(testClass);
            ServerTest testAnnot = testClass.getAnnotation(ServerTest.class);
            if (testAnnot == null) {
                throw new IllegalStateException("Invalid test class for this extension: " + String.valueOf(testClass));
            }
            if (testAnnot.pinningDetection()) {
                this.pinningRecorder = PinningRecorder.create();
                this.pinningRecorder.record(Duration.ofMillis(testAnnot.pinningThreshold()));
            }
            WebServerConfig.Builder builder = WebServer.builder();
            ((WebServerConfig.Builder)builder.config(GlobalConfig.config().get("server"))).host("localhost");
            this.extensions.forEach(it -> it.beforeAll(context));
            this.extensions.forEach(it -> it.updateServerBuilder(builder));
            ((WebServerConfig.Builder)builder.port(0)).shutdownHook(false);
            this.setupFeatures(builder);
            this.setupServer(builder);
            this.addRouting(builder);
            this.server = ((WebServerConfig.Builder)builder.serverContext((Context)this.staticContext(context).orElseThrow())).build().start();
            if (this.server.hasTls()) {
                this.uris.put("@default", URI.create("https://localhost:" + this.server.port() + "/"));
            } else {
                this.uris.put("@default", URI.create("http://localhost:" + this.server.port() + "/"));
            }
        });
    }

    @Override
    public void afterAll(ExtensionContext extensionContext) {
        this.run(extensionContext, () -> {
            this.extensions.forEach(it -> it.afterAll(extensionContext));
            if (this.server != null) {
                this.server.stop();
            }
            super.afterAll(extensionContext);
            if (this.pinningRecorder != null) {
                this.pinningRecorder.close();
                this.pinningRecorder = null;
            }
        });
    }

    public void afterEach(ExtensionContext extensionContext) {
        this.runChecked(extensionContext, () -> this.extensions.forEach(it -> it.afterEach(extensionContext)));
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return (Boolean)this.supplyChecked(extensionContext, () -> {
            Class<?> paramType = parameterContext.getParameter().getType();
            if (paramType.equals(WebServer.class)) {
                return true;
            }
            if (paramType.equals(URI.class)) {
                return true;
            }
            for (ServerJunitExtension extension : this.extensions) {
                if (!extension.supportsParameter(parameterContext, extensionContext)) continue;
                return true;
            }
            Context context = this.server == null ? Contexts.context().orElseGet(Contexts::globalContext) : this.server.context();
            if (context.get(paramType).isPresent()) {
                return true;
            }
            return super.supportsParameter(parameterContext, extensionContext);
        });
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.supplyChecked(extensionContext, () -> {
            Class<?> paramType = parameterContext.getParameter().getType();
            if (paramType.equals(WebServer.class)) {
                return this.server;
            }
            if (paramType.equals(URI.class)) {
                return this.uri(parameterContext.getDeclaringExecutable(), Junit5Util.socketName(parameterContext.getParameter()));
            }
            for (ServerJunitExtension extension : this.extensions) {
                if (!extension.supportsParameter(parameterContext, extensionContext)) continue;
                return extension.resolveParameter(parameterContext, extensionContext, paramType, this.server);
            }
            Context context = this.server == null ? Contexts.context().orElseGet(Contexts::globalContext) : this.server.context();
            Optional fromContext = context.get(paramType);
            if (fromContext.isPresent()) {
                return fromContext;
            }
            return super.resolveParameter(parameterContext, extensionContext);
        });
    }

    private URI uri(Executable declaringExecutable, String socketName) {
        URI uri = this.uris.computeIfAbsent(socketName, it -> {
            int port = this.server.port(it);
            if (port == -1) {
                return null;
            }
            if (this.server.hasTls(it)) {
                return URI.create("https://localhost:" + port + "/");
            }
            return URI.create("http://localhost:" + port + "/");
        });
        if (uri == null) {
            throw new IllegalStateException(String.valueOf(declaringExecutable) + " expects injection of URI parameter for socket named " + socketName + ", which is not available on the running webserver");
        }
        return uri;
    }

    private void addRouting(WebServerConfig.Builder builder) {
        HashMap<String, ListenerConfig.Builder> listenerConfigs = new HashMap<String, ListenerConfig.Builder>();
        HashMap<String, Router.Builder> routerBuilders = new HashMap<String, Router.Builder>();
        listenerConfigs.put("@default", (ListenerConfig.Builder)ListenerConfig.builder().from((ListenerConfig.BuilderBase)builder));
        Junit5Util.withStaticMethods(this.testClass(), SetUpRoute.class, (setUpRoute, method) -> {
            String socketName = setUpRoute.value();
            SetUpRouteHandler methodConsumer = this.createRoutingMethodCall((Method)method);
            ListenerConfig.Builder socketBuilder = listenerConfigs.computeIfAbsent(socketName, it -> ListenerConfig.builder());
            Router.RouterBuilder route = (Router.RouterBuilder)routerBuilders.computeIfAbsent(socketName, it -> Router.builder());
            this.extensions.forEach(it -> it.updateListenerBuilder(socketName, socketBuilder, route));
            methodConsumer.handle(socketName, builder, socketBuilder, route);
        });
        routerBuilders.forEach((socketName, routerBuilder) -> {
            if ("@default".equals(socketName)) {
                builder.addRoutings(routerBuilder.routings());
            } else {
                listenerConfigs.computeIfAbsent((String)socketName, it -> ListenerConfig.builder()).addRoutings(routerBuilder.routings());
            }
        });
        listenerConfigs.forEach((socketName, listenerBuilder) -> {
            if ("@default".equals(socketName)) {
                builder.from((ListenerConfig.BuilderBase)listenerBuilder);
            } else {
                ListenerConfig listenerConfig = (ListenerConfig)builder.sockets().get(socketName);
                if (listenerConfig == null) {
                    builder.putSocket(socketName, listenerBuilder.build());
                } else {
                    builder.putSocket(socketName, ((ListenerConfig.Builder)ListenerConfig.builder((ListenerConfig)listenerConfig).from((ListenerConfig.BuilderBase)listenerBuilder)).build());
                }
            }
        });
    }

    private SetUpRouteHandler createRoutingMethodCall(Method method) {
        Parameter[] parameters;
        ArrayList handlers = new ArrayList();
        for (Parameter parameter : parameters = method.getParameters()) {
            Class<?> paramType = parameter.getType();
            boolean found = false;
            for (ServerJunitExtension extension : this.extensions) {
                Optional<ServerJunitExtension.ParamHandler<?>> paramHandler = extension.setUpRouteParamHandler(paramType);
                if (!paramHandler.isPresent()) continue;
                handlers.add(paramHandler.get());
                found = true;
                break;
            }
            if (found) continue;
            throw new IllegalArgumentException("Method " + String.valueOf(method) + " has a parameter " + String.valueOf(paramType) + " that is not supported by any available testing extension");
        }
        return (socketName, serverBuilder, listenerBuilder, routerBuilder) -> {
            int i;
            Object[] values = new Object[handlers.size()];
            for (i = 0; i < handlers.size(); ++i) {
                ServerJunitExtension.ParamHandler handler = (ServerJunitExtension.ParamHandler)handlers.get(i);
                values[i] = handler.get(socketName, serverBuilder, listenerBuilder, routerBuilder);
            }
            try {
                method.setAccessible(true);
                method.invoke(null, values);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException("Cannot invoke router/socket method", e);
            }
            for (i = 0; i < values.length; ++i) {
                Object value = values[i];
                ServerJunitExtension.ParamHandler handler = (ServerJunitExtension.ParamHandler)handlers.get(i);
                handler.handle(socketName, serverBuilder, listenerBuilder, routerBuilder, value);
            }
        };
    }

    private static interface SetUpRouteHandler {
        public void handle(String var1, WebServerConfig.Builder var2, ListenerConfig.Builder var3, Router.RouterBuilder<?> var4);
    }
}

