/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.testing.junit5;

import io.helidon.common.Builder;
import io.helidon.common.testing.http.junit5.SocketHttpClient;
import io.helidon.webclient.api.WebClient;
import io.helidon.webclient.api.WebClientConfig;
import io.helidon.webclient.http1.Http1Client;
import io.helidon.webclient.http1.Http1ClientConfig;
import io.helidon.webserver.ListenerConfig;
import io.helidon.webserver.Router;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.WebServerConfig;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.http.HttpRules;
import io.helidon.webserver.testing.junit5.Junit5Util;
import io.helidon.webserver.testing.junit5.spi.ServerJunitExtension;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;

public class Http1ServerJunitExtension
implements ServerJunitExtension {
    private final Map<String, SocketHttpClient> socketHttpClients = new ConcurrentHashMap<String, SocketHttpClient>();
    private final Map<String, Http1Client> httpClients = new ConcurrentHashMap<String, Http1Client>();
    private final Map<String, WebClient> webClients = new ConcurrentHashMap<String, WebClient>();

    @Override
    public void afterEach(ExtensionContext context) {
        this.socketHttpClients.values().forEach(SocketHttpClient::disconnect);
    }

    @Override
    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> paramType = parameterContext.getParameter().getType();
        if (paramType.equals(Http1Client.class)) {
            return true;
        }
        if (paramType.equals(SocketHttpClient.class)) {
            return true;
        }
        return paramType.equals(WebClient.class);
    }

    @Override
    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext, Class<?> parameterType, WebServer server) {
        if (parameterType.equals(SocketHttpClient.class)) {
            return this.socketHttpClients.computeIfAbsent(Junit5Util.socketName(parameterContext.getParameter()), it -> this.socketHttpClient(server, (String)it));
        }
        if (parameterType.equals(Http1Client.class)) {
            return this.httpClients.computeIfAbsent(Junit5Util.socketName(parameterContext.getParameter()), it -> this.httpClient(server, (String)it));
        }
        if (parameterType.equals(WebClient.class)) {
            return this.webClients.computeIfAbsent(Junit5Util.socketName(parameterContext.getParameter()), it -> this.webClient(server, (String)it));
        }
        throw new ParameterResolutionException("Parameter of type " + parameterType.getName() + " not supported");
    }

    @Override
    public Optional<ServerJunitExtension.ParamHandler<?>> setUpRouteParamHandler(Class<?> type) {
        if (ListenerConfig.Builder.class.equals(type)) {
            return Optional.of(new ListenerConfigurationParamHandler());
        }
        if (Router.RouterBuilder.class.equals(type)) {
            return Optional.of(new RouterParamHandler());
        }
        if (HttpRules.class.equals(type) || HttpRouting.Builder.class.equals(type)) {
            return Optional.of(new RoutingParamHandler());
        }
        return Optional.empty();
    }

    private WebClient webClient(WebServer server, String socketName) {
        return ((WebClientConfig.Builder)WebClient.builder().baseUri("http://localhost:" + server.port(socketName))).build();
    }

    private Http1Client httpClient(WebServer server, String socketName) {
        return ((Http1ClientConfig.Builder)Http1Client.builder().baseUri("http://localhost:" + server.port(socketName))).build();
    }

    private SocketHttpClient socketHttpClient(WebServer server, String socketName) {
        return SocketHttpClient.create((int)server.port(socketName));
    }

    private static class ListenerConfigurationParamHandler
    implements ServerJunitExtension.ParamHandler<ListenerConfig.Builder> {
        private ListenerConfigurationParamHandler() {
        }

        @Override
        public ListenerConfig.Builder get(String socketName, WebServerConfig.Builder serverBuilder, ListenerConfig.Builder listenerBuilder, Router.RouterBuilder<?> routerBuilder) {
            return listenerBuilder;
        }
    }

    private static class RouterParamHandler
    implements ServerJunitExtension.ParamHandler<Router.RouterBuilder<?>> {
        private RouterParamHandler() {
        }

        @Override
        public Router.RouterBuilder<?> get(String socketName, WebServerConfig.Builder serverBuilder, ListenerConfig.Builder listenerBuilder, Router.RouterBuilder<?> routerBuilder) {
            return routerBuilder;
        }
    }

    private static class RoutingParamHandler
    implements ServerJunitExtension.ParamHandler<HttpRouting.Builder> {
        private RoutingParamHandler() {
        }

        @Override
        public HttpRouting.Builder get(String socketName, WebServerConfig.Builder serverBuilder, ListenerConfig.Builder listenerBuilder, Router.RouterBuilder<?> routerBuilder) {
            return HttpRouting.builder();
        }

        @Override
        public void handle(String socketName, WebServerConfig.Builder serverBuilder, ListenerConfig.Builder listenerBuilder, Router.RouterBuilder<?> routerBuilder, HttpRouting.Builder value) {
            routerBuilder.addRouting((Builder)value);
        }
    }
}

