/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.testing.junit5.websocket;

import io.helidon.webclient.websocket.WsClient;
import io.helidon.webserver.spi.ServerFeature;
import io.helidon.webserver.testing.junit5.Junit5Util;
import io.helidon.webserver.testing.junit5.spi.DirectJunitExtension;
import io.helidon.webserver.testing.junit5.websocket.DirectWsClient;
import io.helidon.webserver.websocket.WsRouting;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;

public class WsDirectExtension
implements DirectJunitExtension {
    private final Map<String, DirectWsClient> clients = new HashMap<String, DirectWsClient>();

    public void afterAll(ExtensionContext context) {
        this.clients.values().forEach(DirectWsClient::close);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> paramType = parameterContext.getParameter().getType();
        return DirectWsClient.class.equals(paramType) || WsClient.class.equals(paramType);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext, Class<?> parameterType) {
        Class<?> paramType = parameterContext.getParameter().getType();
        if (DirectWsClient.class.equals(paramType) || WsClient.class.equals(paramType)) {
            String socketName = Junit5Util.socketName((Parameter)parameterContext.getParameter());
            DirectWsClient directClient = this.clients.get(socketName);
            if (directClient == null) {
                if ("@default".equals(socketName)) {
                    throw new IllegalStateException("There is no WebSocket routing specified. Please add static method annotated with @SetUpRoute that accepts WebSocketRouting.Builder");
                }
                throw new IllegalStateException("There is no default routing specified for socket \"" + socketName + "\".annotated with @SetUpRoute that accepts WebSocketRouting.Builder and add @Socket(\"" + socketName + "\") annotation to the parameter");
            }
            return directClient;
        }
        throw new ParameterResolutionException("Parameter not supported by this extension: " + String.valueOf(parameterType));
    }

    public Optional<DirectJunitExtension.ParamHandler<?>> setUpRouteParamHandler(List<ServerFeature> features, Class<?> type) {
        if (WsRouting.Builder.class.equals(type)) {
            return Optional.of(new RoutingParamHandler(this.clients));
        }
        return Optional.empty();
    }

    private static final class RoutingParamHandler
    implements DirectJunitExtension.ParamHandler<WsRouting.Builder> {
        private final Map<String, DirectWsClient> clients;

        private RoutingParamHandler(Map<String, DirectWsClient> clients) {
            this.clients = clients;
        }

        public WsRouting.Builder get(String socketName) {
            return WsRouting.builder();
        }

        public void handle(Method method, String socketName, WsRouting.Builder value) {
            if (this.clients.putIfAbsent(socketName, DirectWsClient.create(value.build())) != null) {
                throw new IllegalStateException("Method " + String.valueOf(method) + " defines WebSocket routing for socket \"" + socketName + "\" that is already defined for class \"" + method.getDeclaringClass().getName() + "\".");
            }
        }
    }
}

