/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.testing.junit5.http2;

import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.DataReader;
import io.helidon.common.socket.SocketContext;
import io.helidon.common.tls.Tls;
import io.helidon.common.tls.TlsConfig;
import io.helidon.http.Method;
import io.helidon.http.WritableHeaders;
import io.helidon.http.http2.FlowControl;
import io.helidon.http.http2.Http2ConnectionWriter;
import io.helidon.http.http2.Http2ErrorCode;
import io.helidon.http.http2.Http2Flag;
import io.helidon.http.http2.Http2FrameData;
import io.helidon.http.http2.Http2FrameHeader;
import io.helidon.http.http2.Http2FrameType;
import io.helidon.http.http2.Http2FrameTypes;
import io.helidon.http.http2.Http2GoAway;
import io.helidon.http.http2.Http2Headers;
import io.helidon.http.http2.Http2HuffmanDecoder;
import io.helidon.http.http2.Http2RstStream;
import io.helidon.http.http2.Http2Setting;
import io.helidon.http.http2.Http2Settings;
import io.helidon.http.http2.Http2Util;
import io.helidon.http.http2.Http2WindowUpdate;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.api.ConnectionKey;
import io.helidon.webclient.api.DefaultDnsResolver;
import io.helidon.webclient.api.DnsAddressLookup;
import io.helidon.webclient.api.Proxy;
import io.helidon.webclient.api.TcpClientConnection;
import io.helidon.webclient.api.WebClient;
import io.helidon.webclient.api.WebClientConfig;
import io.helidon.webclient.spi.DnsResolver;
import java.io.UncheckedIOException;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class Http2TestConnection
implements AutoCloseable {
    private static final System.Logger LOGGER = System.getLogger(Http2TestConnection.class.getName());
    private static final int FRAME_HEADER_LENGTH = 9;
    private final TcpClientConnection conn;
    private final Http2ConnectionWriter dataWriter;
    private final DataReader reader;
    private final ArrayBlockingQueue<Http2FrameData> readQueue = new ArrayBlockingQueue(100);
    private final Thread readThread;
    private final ClientUri clientUri;
    private final Http2Headers.DynamicTable requestDynamicTable = Http2Headers.DynamicTable.create((long)((Long)Http2Setting.HEADER_TABLE_SIZE.defaultValue()));
    private final Http2HuffmanDecoder requestHuffman = Http2HuffmanDecoder.create();

    Http2TestConnection(URI uri) {
        this.clientUri = ClientUri.create((URI)uri);
        ConnectionKey connectionKey = ConnectionKey.create((String)this.clientUri.scheme(), (String)this.clientUri.host(), (int)this.clientUri.port(), (Tls)((TlsConfig.Builder)Tls.builder().enabled(false)).build(), (DnsResolver)DefaultDnsResolver.create(), (DnsAddressLookup)DnsAddressLookup.defaultLookup(), (Proxy)Proxy.noProxy());
        this.conn = TcpClientConnection.create((WebClient)((WebClientConfig.Builder)WebClient.builder().baseUri(this.clientUri)).build(), (ConnectionKey)connectionKey, List.of(), connection -> false, connection -> {}).connect();
        this.conn.writer().writeNow(Http2Util.prefaceData());
        this.reader = this.conn.reader();
        this.dataWriter = new Http2ConnectionWriter((SocketContext)this.conn.helidonSocket(), this.conn.writer(), List.of());
        this.readThread = Thread.ofVirtual().start(() -> {
            try {
                while (true) {
                    if (Thread.interrupted()) {
                        return;
                    }
                    BufferData frameHeaderBuffer = this.reader.readBuffer(9);
                    Http2FrameHeader frameHeader = Http2FrameHeader.create((BufferData)frameHeaderBuffer);
                    LOGGER.log(System.Logger.Level.DEBUG, () -> "<-- " + String.valueOf(frameHeader));
                    this.readQueue.add(new Http2FrameData(frameHeader, this.reader.readBuffer(frameHeader.length())));
                }
            }
            catch (DataReader.InsufficientDataAvailableException | UncheckedIOException throwable) {
                return;
            }
        });
        this.sendSettings(Http2Settings.builder().add(Http2Setting.INITIAL_WINDOW_SIZE, (Object)65535L).add(Http2Setting.MAX_FRAME_SIZE, (Object)16384L).add(Http2Setting.ENABLE_PUSH, (Object)false).build());
    }

    public Http2TestConnection sendSettings(Http2Settings http2Settings) {
        Http2Flag.SettingsFlags flags = Http2Flag.SettingsFlags.create((int)0);
        Http2FrameData frameData = http2Settings.toFrameData(null, 0, flags);
        this.writer().write(frameData);
        return this;
    }

    public Http2ConnectionWriter writer() {
        return this.dataWriter;
    }

    public Http2TestConnection request(int streamId, Method method, String path, WritableHeaders<?> headers, BufferData payload) {
        Http2Headers h2Headers = Http2Headers.create(headers);
        h2Headers.method(method);
        h2Headers.path(path);
        h2Headers.scheme(this.clientUri().scheme());
        this.writer().writeHeaders(h2Headers, streamId, Http2Flag.HeaderFlags.create((int)4), FlowControl.Outbound.NOOP);
        Http2FrameData frameDataData = new Http2FrameData(Http2FrameHeader.create((int)payload.available(), (Http2FrameTypes)Http2FrameTypes.DATA, (Http2Flag)Http2Flag.DataFlags.create((int)1), (int)streamId), payload);
        this.writer().writeData(frameDataData, FlowControl.Outbound.NOOP);
        return this;
    }

    public Http2FrameData awaitNextFrame(Duration timeout) {
        try {
            return this.readQueue.poll(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public Http2RstStream assertRstStream(int streamId, Duration timeout) {
        Http2FrameData frame = this.assertNextFrame(Http2FrameType.RST_STREAM, timeout);
        MatcherAssert.assertThat((String)"Stream ID doesn't match.", (Object)frame.header().streamId(), (Matcher)Matchers.equalTo((Object)streamId));
        return Http2RstStream.create((BufferData)frame.data());
    }

    public Http2Settings assertSettings(Duration timeout) {
        Http2FrameData frame = this.assertNextFrame(Http2FrameType.SETTINGS, timeout);
        return Http2Settings.create((BufferData)frame.data());
    }

    public Http2WindowUpdate assertWindowsUpdate(int streamId, Duration timeout) {
        Http2FrameData frame = this.assertNextFrame(Http2FrameType.WINDOW_UPDATE, timeout);
        MatcherAssert.assertThat((Object)frame.header().streamId(), (Matcher)Matchers.equalTo((Object)streamId));
        return Http2WindowUpdate.create((BufferData)frame.data());
    }

    public Http2Headers assertHeaders(int streamId, Duration timeout) {
        Http2FrameData frame = this.assertNextFrame(Http2FrameType.HEADERS, timeout);
        MatcherAssert.assertThat((Object)frame.header().streamId(), (Matcher)Matchers.equalTo((Object)streamId));
        return Http2Headers.create(null, (Http2Headers.DynamicTable)this.requestDynamicTable, (Http2HuffmanDecoder)this.requestHuffman, (Http2FrameData[])new Http2FrameData[]{frame});
    }

    public Http2FrameData assertNextFrame(Http2FrameType frameType, Duration timeout) {
        Http2FrameData frame = this.awaitNextFrame(timeout);
        MatcherAssert.assertThat((Object)frame.header().type(), (Matcher)Matchers.equalTo((Object)frameType));
        return frame;
    }

    public Http2FrameData assertGoAway(Http2ErrorCode errorCode, String message, Duration timeout) {
        Http2FrameData frame = this.assertNextFrame(Http2FrameType.GO_AWAY, timeout);
        Http2GoAway goAway = Http2GoAway.create((BufferData)frame.data());
        MatcherAssert.assertThat((Object)goAway.errorCode(), (Matcher)Matchers.is((Object)errorCode));
        MatcherAssert.assertThat((Object)frame.data().readString(frame.data().available()), (Matcher)Matchers.is((Object)message));
        return frame;
    }

    @Override
    public void close() {
        this.readThread.interrupt();
        this.conn.closeResource();
    }

    public ClientUri clientUri() {
        return this.clientUri;
    }
}

