/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.testing.junit5.http2;

import io.helidon.webclient.http2.Http2Client;
import io.helidon.webclient.http2.Http2ClientConfig;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.testing.junit5.Junit5Util;
import io.helidon.webserver.testing.junit5.spi.ServerJunitExtension;
import java.lang.reflect.Parameter;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;

public class Http2ServerExtension
implements ServerJunitExtension {
    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return Http2Client.class.equals(parameterContext.getParameter().getType());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext, Class<?> parameterType, WebServer server) {
        String socketName = Junit5Util.socketName((Parameter)parameterContext.getParameter());
        if (Http2Client.class.equals(parameterType)) {
            return ((Http2ClientConfig.Builder)Http2Client.builder().baseUri("http://localhost:" + server.port(socketName))).build();
        }
        throw new ParameterResolutionException("HTTP/2 extension only supports Http2Client parameter type");
    }
}

