/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient;

import io.helidon.common.http.Http;
import io.helidon.common.http.HttpRequest;
import io.helidon.common.http.Parameters;
import io.helidon.common.http.ReadOnlyParameters;
import io.helidon.webclient.Proxy;
import io.helidon.webclient.RequestConfiguration;
import io.helidon.webclient.WebClientRequestBuilder;
import io.helidon.webclient.WebClientRequestBuilderImpl;
import io.helidon.webclient.WebClientRequestHeaders;
import io.helidon.webclient.WebClientRequestHeadersImpl;
import java.net.URI;
import java.util.Map;

class WebClientRequestImpl
implements WebClientRequestBuilder.ClientRequest {
    private final URI uri;
    private final RequestConfiguration requestConfiguration;
    private final WebClientRequestHeaders clientRequestHeaders;
    private final Http.RequestMethod requestMethod;
    private final Http.Version httpVersion;
    private final Parameters queryParams;
    private final HttpRequest.Path path;
    private final Proxy proxy;
    private final String query;
    private final String fragment;
    private final int redirectionCount;
    private final Map<String, String> properties;

    WebClientRequestImpl(WebClientRequestBuilderImpl builder) {
        this.clientRequestHeaders = new WebClientRequestHeadersImpl(builder.headers());
        this.requestMethod = builder.method();
        this.httpVersion = builder.httpVersion();
        this.uri = builder.uri();
        this.queryParams = new ReadOnlyParameters(builder.queryParams());
        this.query = builder.query();
        this.fragment = builder.fragment();
        this.path = builder.path();
        this.requestConfiguration = builder.requestConfiguration();
        this.proxy = builder.proxy();
        this.redirectionCount = builder.redirectionCount();
        this.properties = Map.copyOf(builder.properties());
    }

    RequestConfiguration configuration() {
        return this.requestConfiguration;
    }

    @Override
    public WebClientRequestHeaders headers() {
        return this.clientRequestHeaders;
    }

    @Override
    public Map<String, String> properties() {
        return this.properties;
    }

    @Override
    public Proxy proxy() {
        return this.proxy;
    }

    @Override
    public int redirectionCount() {
        return this.redirectionCount;
    }

    public Http.RequestMethod method() {
        return this.requestMethod;
    }

    public Http.Version version() {
        return this.httpVersion;
    }

    public URI uri() {
        return this.uri;
    }

    public String query() {
        return this.query;
    }

    public Parameters queryParams() {
        return this.queryParams;
    }

    public HttpRequest.Path path() {
        return this.path;
    }

    public String fragment() {
        return this.fragment;
    }
}

