/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient;

import io.helidon.common.GenericType;
import io.helidon.common.context.Context;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.Headers;
import io.helidon.common.http.Http;
import io.helidon.common.http.HttpRequest;
import io.helidon.common.http.MediaType;
import io.helidon.common.http.Parameters;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.MessageBodyReaderContext;
import io.helidon.media.common.MessageBodyWriterContext;
import io.helidon.webclient.Proxy;
import io.helidon.webclient.WebClientRequestHeaders;
import io.helidon.webclient.WebClientResponse;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.Flow;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public interface WebClientRequestBuilder {
    public WebClientRequestBuilder uri(String var1);

    public WebClientRequestBuilder uri(URL var1);

    public WebClientRequestBuilder uri(URI var1);

    public WebClientRequestBuilder skipUriEncoding();

    public WebClientRequestBuilder followRedirects(boolean var1);

    public WebClientRequestBuilder property(String var1, String var2);

    public WebClientRequestBuilder context(Context var1);

    public WebClientRequestHeaders headers();

    public WebClientRequestBuilder queryParam(String var1, String ... var2);

    public WebClientRequestBuilder proxy(Proxy var1);

    public WebClientRequestBuilder headers(Headers var1);

    public WebClientRequestBuilder headers(Function<WebClientRequestHeaders, Headers> var1);

    default public WebClientRequestBuilder addHeader(String name, String ... values) {
        this.headers().add(name, values);
        return this;
    }

    default public WebClientRequestBuilder addHeader(String name, Iterable<String> values) {
        this.headers().add(name, values);
        return this;
    }

    default public WebClientRequestBuilder addHeaders(Parameters parameters) {
        this.headers().addAll(parameters);
        return this;
    }

    public WebClientRequestBuilder queryParams(Parameters var1);

    public MessageBodyReaderContext readerContext();

    public MessageBodyWriterContext writerContext();

    public WebClientRequestBuilder httpVersion(Http.Version var1);

    public WebClientRequestBuilder connectTimeout(long var1, TimeUnit var3);

    public WebClientRequestBuilder readTimeout(long var1, TimeUnit var3);

    public WebClientRequestBuilder fragment(String var1);

    public WebClientRequestBuilder path(HttpRequest.Path var1);

    public WebClientRequestBuilder path(String var1);

    public WebClientRequestBuilder contentType(MediaType var1);

    public WebClientRequestBuilder accept(MediaType ... var1);

    public WebClientRequestBuilder keepAlive(boolean var1);

    public WebClientRequestBuilder requestId(long var1);

    public WebClientRequestBuilder allowChunkedEncoding(boolean var1);

    public <T> Single<T> request(Class<T> var1);

    public <T> Single<T> request(GenericType<T> var1);

    public Single<WebClientResponse> request();

    public Single<WebClientResponse> submit();

    public <T> Single<T> submit(Flow.Publisher<DataChunk> var1, Class<T> var2);

    public <T> Single<T> submit(Object var1, Class<T> var2);

    public Single<WebClientResponse> submit(Flow.Publisher<DataChunk> var1);

    public Single<WebClientResponse> submit(Object var1);

    public Single<WebClientResponse> submit(Function<MessageBodyWriterContext, Flow.Publisher<DataChunk>> var1);

    public static interface ClientRequest
    extends HttpRequest {
        public WebClientRequestHeaders headers();

        public Map<String, String> properties();

        public Proxy proxy();

        public int redirectionCount();
    }
}

