/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient;

import io.helidon.common.LazyValue;
import io.helidon.common.context.Contexts;
import io.helidon.common.http.Http;
import io.helidon.config.Config;
import io.helidon.media.common.MediaContext;
import io.helidon.webclient.DnsResolverType;
import io.helidon.webclient.Proxy;
import io.helidon.webclient.WebClient;
import io.helidon.webclient.WebClientConfiguration;
import io.helidon.webclient.WebClientRequestBuilder;
import io.helidon.webclient.WebClientRequestBuilderImpl;
import io.helidon.webclient.WebClientTls;
import io.netty.channel.nio.NioEventLoopGroup;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

final class NettyClient
implements WebClient {
    private static final Duration DEFAULT_CONNECT_TIMEOUT = Duration.ofMinutes(1L);
    private static final Duration DEFAULT_READ_TIMEOUT = Duration.ofMinutes(10L);
    private static final boolean DEFAULT_FOLLOW_REDIRECTS = false;
    private static final boolean DEFAULT_KEEP_ALIVE = true;
    private static final boolean DEFAULT_VALIDATE_HEADERS = true;
    private static final int DEFAULT_NUMBER_OF_REDIRECTS = 5;
    private static final LazyValue<String> DEFAULT_USER_AGENT = LazyValue.create(() -> "Helidon/2.6.14 (java " + System.getProperty("java.runtime.version") + ")");
    private static final Proxy DEFAULT_PROXY = Proxy.noProxy();
    private static final MediaContext DEFAULT_MEDIA_SUPPORT = MediaContext.create();
    private static final WebClientTls DEFAULT_TLS = WebClientTls.builder().build();
    private static final DnsResolverType DEFAULT_DNS_RESOLVER_TYPE = DnsResolverType.DEFAULT;
    private static final Config GLOBAL_CLIENT_CONFIG;
    static final WebClientConfiguration SHARED_CONFIGURATION;
    private static final LazyValue<NioEventLoopGroup> EVENT_GROUP;
    private final WebClientConfiguration configuration;

    NettyClient(WebClient.Builder builder) {
        this.configuration = builder.configuration();
    }

    static NioEventLoopGroup eventGroup() {
        return (NioEventLoopGroup)EVENT_GROUP.get();
    }

    @Override
    public WebClientRequestBuilder put() {
        return this.method((Http.RequestMethod)Http.Method.PUT);
    }

    @Override
    public WebClientRequestBuilder get() {
        return this.method((Http.RequestMethod)Http.Method.GET);
    }

    @Override
    public WebClientRequestBuilder post() {
        return this.method((Http.RequestMethod)Http.Method.POST);
    }

    @Override
    public WebClientRequestBuilder delete() {
        return this.method((Http.RequestMethod)Http.Method.DELETE);
    }

    @Override
    public WebClientRequestBuilder options() {
        return this.method((Http.RequestMethod)Http.Method.OPTIONS);
    }

    @Override
    public WebClientRequestBuilder trace() {
        return this.method((Http.RequestMethod)Http.Method.TRACE);
    }

    @Override
    public WebClientRequestBuilder head() {
        return this.method((Http.RequestMethod)Http.Method.HEAD);
    }

    @Override
    public WebClientRequestBuilder method(String method) {
        return WebClientRequestBuilderImpl.create((NioEventLoopGroup)EVENT_GROUP.get(), this.configuration, Http.RequestMethod.create((String)method));
    }

    @Override
    public WebClientRequestBuilder method(Http.RequestMethod method) {
        return WebClientRequestBuilderImpl.create((NioEventLoopGroup)EVENT_GROUP.get(), this.configuration, method);
    }

    static {
        Config globalConfig = Contexts.globalContext().get(Config.class).orElseGet(Config::empty);
        GLOBAL_CLIENT_CONFIG = globalConfig.get("client");
        SHARED_CONFIGURATION = ((WebClientConfiguration.Builder)((WebClientConfiguration.Builder)((WebClientConfiguration.Builder)((WebClientConfiguration.Builder)((WebClientConfiguration.Builder)((WebClientConfiguration.Builder)((WebClientConfiguration.Builder)((WebClientConfiguration.Builder)((WebClientConfiguration.Builder)((WebClientConfiguration.Builder)((WebClientConfiguration.Builder)((WebClientConfiguration.Builder)((WebClientConfiguration.Builder)WebClientConfiguration.builder().connectTimeout(DEFAULT_CONNECT_TIMEOUT)).readTimeout(DEFAULT_READ_TIMEOUT)).followRedirects(false)).maxRedirects(5)).userAgent(DEFAULT_USER_AGENT)).readerContextParent(DEFAULT_MEDIA_SUPPORT.readerContext())).writerContextParent(DEFAULT_MEDIA_SUPPORT.writerContext())).proxy(DEFAULT_PROXY)).tls(DEFAULT_TLS)).keepAlive(true)).validateHeaders(true)).dnsResolverType(DEFAULT_DNS_RESOLVER_TYPE)).config(GLOBAL_CLIENT_CONFIG)).build();
        EVENT_GROUP = LazyValue.create(() -> {
            Config eventLoopConfig = GLOBAL_CLIENT_CONFIG.get("event-loop");
            int numberOfThreads = (Integer)eventLoopConfig.get("workers").asInt().orElse((Object)1);
            String threadNamePrefix = (String)eventLoopConfig.get("name-prefix").asString().orElse((Object)"helidon-client-");
            AtomicInteger threadCounter = new AtomicInteger();
            ThreadFactory threadFactory = r -> {
                Thread result = new Thread(r, threadNamePrefix + threadCounter.getAndIncrement());
                result.setDaemon(true);
                return result;
            };
            ExecutorService executorService = Executors.newCachedThreadPool(threadFactory);
            return new NioEventLoopGroup(numberOfThreads, (Executor)Contexts.wrap((ExecutorService)executorService));
        });
    }
}

