/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient;

import io.helidon.common.context.Context;
import io.helidon.common.http.Http;
import io.helidon.common.http.HttpRequest;
import io.helidon.common.http.Parameters;
import io.helidon.common.reactive.Single;
import io.helidon.webclient.WebClientRequestBuilderImpl;
import io.helidon.webclient.WebClientRequestHeaders;
import io.helidon.webclient.WebClientServiceRequest;
import io.helidon.webclient.WebClientServiceResponse;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

class WebClientServiceRequestImpl
implements WebClientServiceRequest {
    private final WebClientRequestHeaders headers;
    private final Http.RequestMethod method;
    private final Http.Version version;
    private final Map<String, String> parameters;
    private final CompletableFuture<WebClientServiceRequest> sent;
    private final CompletableFuture<WebClientServiceResponse> responseReceived;
    private final CompletableFuture<WebClientServiceResponse> complete;
    private final WebClientRequestBuilderImpl requestBuilder;
    private String schema;
    private String host;
    private int port;

    WebClientServiceRequestImpl(WebClientRequestBuilderImpl requestBuilder, CompletableFuture<WebClientServiceRequest> sent, CompletableFuture<WebClientServiceResponse> responseReceived, CompletableFuture<WebClientServiceResponse> complete) {
        this.headers = requestBuilder.headers();
        this.method = requestBuilder.method();
        this.version = requestBuilder.httpVersion();
        this.responseReceived = responseReceived;
        this.parameters = requestBuilder.properties();
        this.sent = sent;
        this.complete = complete;
        this.requestBuilder = requestBuilder;
        URI uri = requestBuilder.uri();
        this.schema = uri.getScheme();
        this.host = uri.getHost();
        this.port = uri.getPort();
    }

    @Override
    public WebClientRequestHeaders headers() {
        return this.headers;
    }

    @Override
    public Context context() {
        return this.requestBuilder.context();
    }

    @Override
    public long requestId() {
        return this.requestBuilder.requestId();
    }

    @Override
    public void requestId(long requestId) {
        this.requestBuilder.requestId(requestId);
    }

    @Override
    public Single<WebClientServiceRequest> whenSent() {
        return Single.create(this.sent);
    }

    @Override
    public Single<WebClientServiceResponse> whenResponseReceived() {
        return Single.create(this.responseReceived);
    }

    @Override
    public Single<WebClientServiceResponse> whenComplete() {
        return Single.create(this.complete);
    }

    @Override
    public Map<String, String> properties() {
        return this.parameters;
    }

    @Override
    public void schema(String schema) {
        this.schema = schema;
    }

    @Override
    public void host(String host) {
        this.host = host;
    }

    @Override
    public void port(int port) {
        this.port = port;
    }

    @Override
    public void path(String path) {
        this.requestBuilder.path(path);
    }

    @Override
    public void fragment(String fragment) {
        this.requestBuilder.fragment(fragment);
    }

    public Http.RequestMethod method() {
        return this.method;
    }

    public Http.Version version() {
        return this.version;
    }

    public URI uri() {
        return this.requestBuilder.uri();
    }

    public String query() {
        return this.requestBuilder.queryFromParams();
    }

    public Parameters queryParams() {
        return this.requestBuilder.queryParams();
    }

    public HttpRequest.Path path() {
        return this.requestBuilder.path();
    }

    public String fragment() {
        return this.requestBuilder.fragment();
    }

    @Override
    public String host() {
        return this.host;
    }

    @Override
    public String schema() {
        return this.schema;
    }

    @Override
    public int port() {
        return this.port;
    }
}

