/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient;

import io.helidon.common.http.HashParameters;
import io.helidon.common.http.Parameters;
import io.helidon.webclient.UriComponentEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

class WebClientQueryParams
implements Parameters {
    private final Parameters rawParams = HashParameters.create();
    private final Parameters encodedParams = HashParameters.create();
    private boolean skipEncoding = false;

    WebClientQueryParams() {
    }

    public Optional<String> first(String name) {
        String key = name;
        if (!this.skipEncoding) {
            key = this.encode(name);
        }
        return this.pickCorrectParameters().first(key);
    }

    public List<String> all(String name) {
        String key = name;
        if (!this.skipEncoding) {
            key = this.encode(name);
        }
        return this.pickCorrectParameters().all(key);
    }

    public List<String> put(String key, String ... values) {
        List<String> toEncode = values == null ? null : Arrays.asList(values);
        this.encodedParams.put(this.encode(key), this.encodeIterable(toEncode));
        return this.rawParams.put(key, values);
    }

    public List<String> put(String key, Iterable<String> values) {
        this.encodedParams.put(this.encode(key), this.encodeIterable(values));
        return this.rawParams.put(key, values);
    }

    public List<String> putIfAbsent(String key, String ... values) {
        List<String> toEncode = values == null ? null : Arrays.asList(values);
        this.encodedParams.putIfAbsent(this.encode(key), this.encodeIterable(toEncode));
        return this.rawParams.putIfAbsent(key, values);
    }

    public List<String> putIfAbsent(String key, Iterable<String> values) {
        this.encodedParams.putIfAbsent(this.encode(key), this.encodeIterable(values));
        return this.rawParams.putIfAbsent(key, values);
    }

    public List<String> computeIfAbsent(String key, Function<String, Iterable<String>> values) {
        this.encodedParams.computeIfAbsent(this.encode(key), k -> this.encodeIterable((Iterable)values.apply(key)));
        return this.rawParams.computeIfAbsent(key, values);
    }

    public List<String> computeSingleIfAbsent(String key, Function<String, String> value) {
        this.encodedParams.computeSingleIfAbsent(this.encode(key), k -> this.encode((String)value.apply((String)k)));
        return this.rawParams.computeSingleIfAbsent(key, value);
    }

    public void putAll(Parameters parameters) {
        if (parameters == null) {
            return;
        }
        this.rawParams.putAll(parameters);
        parameters.toMap().forEach((key, value) -> this.encodedParams.put(this.encode((String)key), this.encodeIterable((Iterable<String>)value)));
    }

    public void add(String key, String ... values) {
        this.rawParams.add(key, values);
        this.encodedParams.add(this.encode(key), this.encodeIterable(Arrays.asList(values)));
    }

    public void add(String key, Iterable<String> values) {
        this.rawParams.add(key, values);
        this.encodedParams.add(this.encode(key), this.encodeIterable(values));
    }

    public void addAll(Parameters parameters) {
        if (parameters == null) {
            return;
        }
        this.rawParams.addAll(parameters);
        parameters.toMap().forEach((key, value) -> this.encodedParams.add(key, this.encodeIterable((Iterable<String>)value)));
    }

    private Iterable<String> encodeIterable(Iterable<String> iterable) {
        if (iterable == null) {
            return null;
        }
        ArrayList<String> toReturn = new ArrayList<String>();
        for (String value : iterable) {
            toReturn.add(this.encode(value));
        }
        return toReturn;
    }

    private String encode(String value) {
        return UriComponentEncoder.encode(value, UriComponentEncoder.Type.QUERY_PARAM);
    }

    public List<String> remove(String key) {
        this.encodedParams.remove(this.encode(key));
        return this.rawParams.remove(key);
    }

    public Map<String, List<String>> toMap() {
        return this.rawParams.toMap();
    }

    void skipEncoding() {
        this.skipEncoding = true;
    }

    Parameters pickCorrectParameters() {
        return this.skipEncoding ? this.rawParams : this.encodedParams;
    }
}

