/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient;

import io.helidon.common.LazyValue;
import io.helidon.common.http.Http;
import io.helidon.config.Config;
import io.helidon.media.common.MediaContext;
import io.helidon.webclient.Proxy;
import io.helidon.webclient.WebClient;
import io.helidon.webclient.WebClientConfiguration;
import io.helidon.webclient.WebClientRequestBuilder;
import io.helidon.webclient.WebClientRequestBuilderImpl;
import io.helidon.webclient.WebClientTls;
import io.netty.channel.nio.NioEventLoopGroup;
import java.time.Duration;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

final class NettyClient
implements WebClient {
    private static final Config EMPTY_CONFIG = Config.empty();
    private static final Duration DEFAULT_CONNECT_TIMEOUT = Duration.ofMinutes(1L);
    private static final Duration DEFAULT_READ_TIMEOUT = Duration.ofMinutes(10L);
    private static final boolean DEFAULT_FOLLOW_REDIRECTS = false;
    private static final boolean DEFAULT_KEEP_ALIVE = true;
    private static final boolean DEFAULT_VALIDATE_HEADERS = true;
    private static final int DEFAULT_NUMBER_OF_REDIRECTS = 5;
    private static final LazyValue<String> DEFAULT_USER_AGENT = LazyValue.create(() -> "Helidon/2.3.0 (java " + System.getProperty("java.runtime.version") + ")");
    private static final Proxy DEFAULT_PROXY = Proxy.noProxy();
    private static final MediaContext DEFAULT_MEDIA_SUPPORT = MediaContext.create();
    private static final WebClientTls DEFAULT_TLS = WebClientTls.builder().build();
    private static final AtomicBoolean DEFAULTS_CONFIGURED = new AtomicBoolean();
    private static final WebClientConfiguration DEFAULT_CONFIGURATION = ((WebClientConfiguration.Builder)((WebClientConfiguration.Builder)((WebClientConfiguration.Builder)((WebClientConfiguration.Builder)((WebClientConfiguration.Builder)((WebClientConfiguration.Builder)((WebClientConfiguration.Builder)((WebClientConfiguration.Builder)((WebClientConfiguration.Builder)((WebClientConfiguration.Builder)((WebClientConfiguration.Builder)((WebClientConfiguration.Builder)WebClientConfiguration.builder().config(EMPTY_CONFIG)).connectTimeout(DEFAULT_CONNECT_TIMEOUT)).readTimeout(DEFAULT_READ_TIMEOUT)).followRedirects(false)).maxRedirects(5)).userAgent(DEFAULT_USER_AGENT)).readerContextParent(DEFAULT_MEDIA_SUPPORT.readerContext())).writerContextParent(DEFAULT_MEDIA_SUPPORT.writerContext())).proxy(DEFAULT_PROXY)).tls(DEFAULT_TLS)).keepAlive(true)).validateHeaders(true)).build();
    static final AtomicReference<WebClientConfiguration> SHARED_CONFIGURATION = new AtomicReference<WebClientConfiguration>(DEFAULT_CONFIGURATION);
    private static LazyValue<NioEventLoopGroup> eventGroup = LazyValue.create(() -> {
        throw new IllegalStateException("Value supplier not yet set");
    });
    private final WebClientConfiguration configuration;

    NettyClient(WebClient.Builder builder) {
        this.configuration = builder.configuration();
        NettyClient.configureDefaults(EMPTY_CONFIG);
    }

    static LazyValue<NioEventLoopGroup> eventGroup() {
        return eventGroup;
    }

    @Override
    public WebClientRequestBuilder put() {
        return this.method((Http.RequestMethod)Http.Method.PUT);
    }

    @Override
    public WebClientRequestBuilder get() {
        return this.method((Http.RequestMethod)Http.Method.GET);
    }

    @Override
    public WebClientRequestBuilder post() {
        return this.method((Http.RequestMethod)Http.Method.POST);
    }

    @Override
    public WebClientRequestBuilder delete() {
        return this.method((Http.RequestMethod)Http.Method.DELETE);
    }

    @Override
    public WebClientRequestBuilder options() {
        return this.method((Http.RequestMethod)Http.Method.OPTIONS);
    }

    @Override
    public WebClientRequestBuilder trace() {
        return this.method((Http.RequestMethod)Http.Method.TRACE);
    }

    @Override
    public WebClientRequestBuilder head() {
        return this.method((Http.RequestMethod)Http.Method.HEAD);
    }

    @Override
    public WebClientRequestBuilder method(String method) {
        return WebClientRequestBuilderImpl.create(eventGroup, this.configuration, Http.RequestMethod.create((String)method));
    }

    @Override
    public WebClientRequestBuilder method(Http.RequestMethod method) {
        return WebClientRequestBuilderImpl.create(eventGroup, this.configuration, method);
    }

    static void configureDefaults(Config globalConfig) {
        if (DEFAULTS_CONFIGURED.compareAndSet(false, true)) {
            Config config = globalConfig.get("client");
            WebClientConfiguration.Builder builder = DEFAULT_CONFIGURATION.derive();
            Config eventLoopConfig = config.get("event-loop");
            int numberOfThreads = (Integer)eventLoopConfig.get("workers").asInt().orElse((Object)1);
            String threadNamePrefix = (String)eventLoopConfig.get("name-prefix").asString().orElse((Object)"helidon-client-");
            AtomicInteger threadCounter = new AtomicInteger();
            ThreadFactory threadFactory = r -> {
                Thread result = new Thread(r, threadNamePrefix + threadCounter.getAndIncrement());
                result.setDaemon(true);
                return result;
            };
            eventGroup = LazyValue.create((Object)new NioEventLoopGroup(numberOfThreads, threadFactory));
            builder.config(config);
            SHARED_CONFIGURATION.set((WebClientConfiguration)builder.build());
        }
    }
}

