/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient;

import io.helidon.common.GenericType;
import io.helidon.common.LazyValue;
import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.HashParameters;
import io.helidon.common.http.Headers;
import io.helidon.common.http.Http;
import io.helidon.common.http.HttpRequest;
import io.helidon.common.http.MediaType;
import io.helidon.common.http.Parameters;
import io.helidon.common.reactive.Single;
import io.helidon.media.common.MessageBodyReadableContent;
import io.helidon.media.common.MessageBodyReaderContext;
import io.helidon.media.common.MessageBodyWriterContext;
import io.helidon.webclient.NettyClient;
import io.helidon.webclient.NettyClientInitializer;
import io.helidon.webclient.Proxy;
import io.helidon.webclient.RequestConfiguration;
import io.helidon.webclient.RequestContentSubscriber;
import io.helidon.webclient.WebClientConfiguration;
import io.helidon.webclient.WebClientException;
import io.helidon.webclient.WebClientRequestBuilder;
import io.helidon.webclient.WebClientRequestHeaders;
import io.helidon.webclient.WebClientRequestHeadersImpl;
import io.helidon.webclient.WebClientRequestImpl;
import io.helidon.webclient.WebClientResponse;
import io.helidon.webclient.WebClientServiceRequest;
import io.helidon.webclient.WebClientServiceRequestImpl;
import io.helidon.webclient.WebClientServiceResponse;
import io.helidon.webclient.spi.WebClientService;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AsciiString;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;

class WebClientRequestBuilderImpl
implements WebClientRequestBuilder {
    static final AttributeKey<WebClientRequestImpl> REQUEST = AttributeKey.valueOf((String)"request");
    private static final AtomicLong REQUEST_NUMBER = new AtomicLong(0L);
    private static final String DEFAULT_TRANSPORT_PROTOCOL = "http";
    private static final Map<String, Integer> DEFAULT_SUPPORTED_PROTOCOLS = new HashMap<String, Integer>();
    private final Map<String, String> properties = new HashMap<String, String>();
    private final LazyValue<NioEventLoopGroup> eventGroup;
    private final WebClientConfiguration configuration;
    private final Http.RequestMethod method;
    private final WebClientRequestHeaders headers;
    private final Parameters queryParams;
    private final AtomicBoolean handled;
    private final MessageBodyReaderContext readerContext;
    private final MessageBodyWriterContext writerContext;
    private URI uri;
    private Http.Version httpVersion;
    private Context context;
    private Proxy proxy;
    private String fragment;
    private boolean followRedirects;
    private boolean skipUriEncoding;
    private int redirectionCount;
    private RequestConfiguration requestConfiguration;
    private HttpRequest.Path path;
    private List<WebClientService> services;
    private Duration readTimeout;
    private Duration connectTimeout;

    private WebClientRequestBuilderImpl(LazyValue<NioEventLoopGroup> eventGroup, WebClientConfiguration configuration, Http.RequestMethod method) {
        this.eventGroup = eventGroup;
        this.configuration = configuration;
        this.method = method;
        this.uri = configuration.uri();
        this.skipUriEncoding = false;
        this.path = ClientPath.create(null, "", new HashMap<String, String>());
        this.headers = new WebClientRequestHeadersImpl(this.configuration.headers());
        this.queryParams = HashParameters.create();
        this.httpVersion = Http.Version.V1_1;
        this.redirectionCount = 0;
        this.services = configuration.clientServices();
        this.readerContext = MessageBodyReaderContext.create((MessageBodyReaderContext)configuration.readerContext());
        this.writerContext = MessageBodyWriterContext.create((MessageBodyWriterContext)configuration.writerContext(), (Parameters)this.headers);
        Context.Builder contextBuilder = Context.builder().id("webclient-" + REQUEST_NUMBER.incrementAndGet());
        configuration.context().ifPresentOrElse(arg_0 -> ((Context.Builder)contextBuilder).parent(arg_0), () -> Contexts.context().ifPresent(arg_0 -> ((Context.Builder)contextBuilder).parent(arg_0)));
        this.context = contextBuilder.build();
        this.handled = new AtomicBoolean();
        this.followRedirects = configuration.followRedirects();
        this.readTimeout = configuration.readTimout();
        this.connectTimeout = configuration.connectTimeout();
        this.proxy = configuration.proxy().orElse(Proxy.noProxy());
    }

    public static WebClientRequestBuilder create(LazyValue<NioEventLoopGroup> eventGroup, WebClientConfiguration configuration, Http.RequestMethod method) {
        return new WebClientRequestBuilderImpl(eventGroup, configuration, method);
    }

    static WebClientRequestBuilder create(WebClientRequestImpl clientRequest) {
        WebClientRequestBuilderImpl builder = new WebClientRequestBuilderImpl(NettyClient.eventGroup(), clientRequest.configuration(), clientRequest.method());
        builder.headers(clientRequest.headers());
        builder.queryParams(clientRequest.queryParams());
        builder.uri = clientRequest.uri();
        builder.httpVersion = clientRequest.version();
        builder.proxy = clientRequest.proxy();
        builder.fragment = clientRequest.fragment();
        builder.redirectionCount = clientRequest.redirectionCount() + 1;
        int maxRedirects = builder.configuration.maxRedirects();
        if (builder.redirectionCount > maxRedirects) {
            throw new WebClientException("Max number of redirects extended! (" + maxRedirects + ")");
        }
        return builder;
    }

    @Override
    public WebClientRequestBuilder uri(String uri) {
        return this.uri(URI.create(uri));
    }

    @Override
    public WebClientRequestBuilder uri(URL url) {
        try {
            return this.uri(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new WebClientException("Failed to create URI from URL", e);
        }
    }

    @Override
    public WebClientRequestBuilder uri(URI uri) {
        this.uri = uri;
        return this;
    }

    @Override
    public WebClientRequestBuilder skipUriEncoding() {
        this.skipUriEncoding = true;
        return this;
    }

    @Override
    public WebClientRequestBuilder followRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    @Override
    public WebClientRequestBuilder property(String propertyName, String propertyValue) {
        this.properties.put(propertyName, propertyValue);
        return this;
    }

    @Override
    public WebClientRequestBuilder context(Context context) {
        this.context = context;
        return this;
    }

    @Override
    public WebClientRequestHeaders headers() {
        return this.headers;
    }

    @Override
    public WebClientRequestBuilder queryParam(String name, String ... values) {
        for (String value : values) {
            this.queryParams.add(name, new String[]{URLEncoder.encode(value, StandardCharsets.UTF_8)});
        }
        return this;
    }

    @Override
    public WebClientRequestBuilder proxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    @Override
    public WebClientRequestBuilder headers(Headers headers) {
        this.headers.clear();
        this.headers.putAll((Parameters)headers);
        return this;
    }

    @Override
    public WebClientRequestBuilder headers(Function<WebClientRequestHeaders, Headers> headers) {
        Headers newHeaders = headers.apply(this.headers);
        if (!newHeaders.equals(this.headers)) {
            this.headers(newHeaders);
        }
        return this;
    }

    @Override
    public WebClientRequestBuilder queryParams(Parameters queryParams) {
        Objects.requireNonNull(queryParams);
        queryParams.toMap().forEach((name, params) -> this.queryParam((String)name, params.toArray(new String[0])));
        return this;
    }

    @Override
    public WebClientRequestBuilder httpVersion(Http.Version httpVersion) {
        this.httpVersion = httpVersion;
        return this;
    }

    @Override
    public WebClientRequestBuilder connectTimeout(long amount, TimeUnit unit) {
        this.connectTimeout = Duration.of(amount, unit.toChronoUnit());
        return this;
    }

    @Override
    public WebClientRequestBuilder readTimeout(long amount, TimeUnit unit) {
        this.readTimeout = Duration.of(amount, unit.toChronoUnit());
        return this;
    }

    @Override
    public WebClientRequestBuilder fragment(String fragment) {
        this.fragment = fragment;
        return this;
    }

    @Override
    public WebClientRequestBuilder path(HttpRequest.Path path) {
        this.path = path;
        return this;
    }

    @Override
    public WebClientRequestBuilder path(String path) {
        this.path = ClientPath.create(null, path, new HashMap<String, String>());
        return this;
    }

    @Override
    public WebClientRequestBuilder contentType(MediaType contentType) {
        this.headers.contentType(contentType);
        return this;
    }

    @Override
    public WebClientRequestBuilder accept(MediaType ... mediaTypes) {
        Arrays.stream(mediaTypes).forEach(this.headers::addAccept);
        return this;
    }

    @Override
    public <T> Single<T> request(Class<T> responseType) {
        return this.request(GenericType.create(responseType));
    }

    @Override
    public <T> Single<T> request(GenericType<T> responseType) {
        return (Single)Contexts.runInContext((Context)this.context, () -> this.invokeWithEntity((Flow.Publisher<DataChunk>)Single.empty(), responseType));
    }

    @Override
    public Single<WebClientResponse> request() {
        return (Single)Contexts.runInContext((Context)this.context, () -> this.invoke((Flow.Publisher<DataChunk>)Single.empty()));
    }

    @Override
    public Single<WebClientResponse> submit() {
        return this.request();
    }

    @Override
    public <T> Single<T> submit(Flow.Publisher<DataChunk> requestEntity, Class<T> responseType) {
        return (Single)Contexts.runInContext((Context)this.context, () -> this.invokeWithEntity(requestEntity, GenericType.create((Class)responseType)));
    }

    @Override
    public <T> Single<T> submit(Object requestEntity, Class<T> responseType) {
        GenericType responseGenericType = GenericType.create(responseType);
        Flow.Publisher dataChunkPublisher = this.writerContext.marshall(Single.just((Object)requestEntity), GenericType.create((Object)requestEntity));
        return (Single)Contexts.runInContext((Context)this.context, () -> this.invokeWithEntity(dataChunkPublisher, responseGenericType));
    }

    @Override
    public Single<WebClientResponse> submit(Flow.Publisher<DataChunk> requestEntity) {
        return (Single)Contexts.runInContext((Context)this.context, () -> this.invoke(requestEntity));
    }

    @Override
    public Single<WebClientResponse> submit(Object requestEntity) {
        Flow.Publisher dataChunkPublisher = this.writerContext.marshall(Single.just((Object)requestEntity), GenericType.create((Object)requestEntity));
        return this.submit(dataChunkPublisher);
    }

    @Override
    public MessageBodyReaderContext readerContext() {
        return this.readerContext;
    }

    @Override
    public MessageBodyWriterContext writerContext() {
        return this.writerContext;
    }

    Http.RequestMethod method() {
        return this.method;
    }

    Http.Version httpVersion() {
        return this.httpVersion;
    }

    URI uri() {
        return this.uri;
    }

    Parameters queryParams() {
        return this.queryParams;
    }

    String query() {
        return this.uri.getQuery() == null ? "" : this.uri.getQuery();
    }

    String fragment() {
        return this.fragment;
    }

    HttpRequest.Path path() {
        return this.path;
    }

    RequestConfiguration requestConfiguration() {
        return this.requestConfiguration;
    }

    Map<String, String> properties() {
        return this.properties;
    }

    Proxy proxy() {
        return this.proxy;
    }

    int redirectionCount() {
        return this.redirectionCount;
    }

    Context context() {
        return this.context;
    }

    private <T> Single<T> invokeWithEntity(Flow.Publisher<DataChunk> requestEntity, GenericType<T> responseType) {
        return this.invoke(requestEntity).map(this::getContentFromClientResponse).flatMapSingle(content -> Single.create((Single)content.as(responseType)));
    }

    private Single<WebClientResponse> invoke(Flow.Publisher<DataChunk> requestEntity) {
        this.uri = this.prepareFinalURI();
        CompletableFuture sent = new CompletableFuture();
        CompletableFuture responseReceived = new CompletableFuture();
        CompletableFuture complete = new CompletableFuture();
        Single singleSent = Single.create(sent);
        Single singleResponseReceived = Single.create(responseReceived);
        Single singleComplete = Single.create(complete);
        WebClientServiceRequestImpl completedRequest = new WebClientServiceRequestImpl(this, (Single<WebClientServiceRequest>)singleSent, (Single<WebClientServiceResponse>)singleResponseReceived, (Single<WebClientServiceResponse>)singleComplete);
        CompletionStage<WebClientServiceRequestImpl> rcs = CompletableFuture.completedFuture(completedRequest);
        for (WebClientService service : this.services) {
            rcs = rcs.thenCompose(service::request);
        }
        return Single.create(rcs.thenCompose(serviceRequest -> {
            HttpHeaders headers = this.toNettyHttpHeaders();
            DefaultHttpRequest request = new DefaultHttpRequest(this.toNettyHttpVersion(this.httpVersion), this.toNettyMethod(this.method), this.uri.toASCIIString(), headers);
            this.requestConfiguration = ((RequestConfiguration.Builder)((RequestConfiguration.Builder)((RequestConfiguration.Builder)((RequestConfiguration.Builder)((RequestConfiguration.Builder)((RequestConfiguration.Builder)((RequestConfiguration.Builder)((RequestConfiguration.Builder)RequestConfiguration.builder(this.uri).update(this.configuration)).followRedirects(this.followRedirects)).clientServiceRequest((WebClientServiceRequest)serviceRequest).readerContext(this.readerContext)).writerContext(this.writerContext)).connectTimeout(this.connectTimeout)).readTimeout(this.readTimeout)).services(this.services).context(this.context)).proxy(this.proxy)).build();
            WebClientRequestImpl clientRequest = new WebClientRequestImpl(this);
            CompletableFuture<WebClientResponse> result = new CompletableFuture<WebClientResponse>();
            EventLoopGroup group = (EventLoopGroup)this.eventGroup.get();
            Bootstrap bootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new NettyClientInitializer(this.requestConfiguration, result, responseReceived, complete))).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)this.connectTimeout.toMillis()));
            ChannelFuture channelFuture = bootstrap.connect(this.uri.getHost(), this.uri.getPort());
            channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                channelFuture.channel().attr(REQUEST).set((Object)clientRequest);
                Throwable cause = future.cause();
                if (null == cause) {
                    RequestContentSubscriber requestContentSubscriber = new RequestContentSubscriber(request, channelFuture.channel(), result, sent);
                    requestEntity.subscribe(requestContentSubscriber);
                } else {
                    sent.completeExceptionally(cause);
                    responseReceived.completeExceptionally(cause);
                    complete.completeExceptionally(cause);
                    result.completeExceptionally(new WebClientException(this.uri.toString(), cause));
                }
            }));
            return result;
        }));
    }

    private MessageBodyReadableContent getContentFromClientResponse(WebClientResponse response) {
        if (response.status().code() >= Http.Status.MOVED_PERMANENTLY_301.code()) {
            throw new WebClientException("Request failed with code " + response.status().code());
        }
        return response.content();
    }

    private URI prepareFinalURI() {
        if (this.handled.compareAndSet(false, true)) {
            int port;
            if (this.uri == null) {
                throw new WebClientException("There is no specified uri for the request.");
            }
            if (this.uri.getHost() == null) {
                throw new WebClientException("Invalid uri " + this.uri + ". Uri.getHost() returned null.");
            }
            String scheme = Optional.ofNullable(this.uri.getScheme()).orElseThrow(() -> new WebClientException("Transport protocol has be to be specified in uri: " + this.uri.toString()));
            if (!DEFAULT_SUPPORTED_PROTOCOLS.containsKey(scheme)) {
                throw new WebClientException(scheme + " transport protocol is not supported!");
            }
            int n = port = this.uri.getPort() > -1 ? this.uri.getPort() : DEFAULT_SUPPORTED_PROTOCOLS.getOrDefault(scheme, -1).intValue();
            if (port == -1) {
                throw new WebClientException("Client could not get port for schema " + scheme + ". Please specify correct port to use.");
            }
            String path = this.resolvePath();
            this.path = ClientPath.create(null, path, new HashMap<String, String>());
            String query = this.resolveQuery();
            this.fragment = this.fragment == null ? this.uri.getFragment() : this.fragment;
            try {
                if (this.skipUriEncoding) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(scheme).append("://").append(this.uri.getHost()).append(":").append(port).append(path);
                    if (query != null) {
                        sb.append('?');
                        sb.append(query);
                    } else if (this.fragment != null) {
                        sb.append('#');
                        sb.append(this.fragment);
                    }
                    return URI.create(sb.toString());
                }
                return new URI(scheme, null, this.uri.getHost(), port, path, query, this.fragment);
            }
            catch (URISyntaxException e) {
                throw new WebClientException("Could not create URI instance for the request.", e);
            }
        }
        return this.uri;
    }

    private String resolveQuery() {
        Object queries = "";
        for (Map.Entry entry : this.queryParams.toMap().entrySet()) {
            for (String value : (List)entry.getValue()) {
                String query = (String)entry.getKey() + "=" + value;
                queries = ((String)queries).isEmpty() ? query : (String)queries + "&" + query;
            }
        }
        if (((String)queries).isEmpty()) {
            queries = this.uri.getQuery();
        } else if (this.uri.getQuery() != null) {
            queries = this.uri.getQuery() + "&" + (String)queries;
        }
        if (this.uri.getQuery() != null) {
            String[] uriQueries = this.uri.getQuery().split("&");
            Arrays.stream(uriQueries).map(s -> s.split("=")).forEach(keyValue -> this.queryParam(keyValue[0], keyValue[1]));
        }
        return queries;
    }

    private String resolvePath() {
        String uriPath = this.uri.getPath();
        String extendedPath = this.path.toRawString();
        if (uriPath.endsWith("/") && extendedPath.startsWith("/")) {
            return uriPath.substring(0, uriPath.length() - 1) + extendedPath;
        }
        if (extendedPath.isEmpty()) {
            return uriPath;
        }
        return uriPath.endsWith("/") || extendedPath.startsWith("/") ? uriPath + extendedPath : uriPath + "/" + extendedPath;
    }

    private HttpMethod toNettyMethod(Http.RequestMethod method) {
        return HttpMethod.valueOf((String)method.name());
    }

    private HttpVersion toNettyHttpVersion(Http.Version version) {
        return HttpVersion.valueOf((String)version.value());
    }

    private HttpHeaders toNettyHttpHeaders() {
        DefaultHttpHeaders headers = new DefaultHttpHeaders();
        try {
            Map<String, List<String>> cookieHeaders = this.configuration.cookieManager().get(this.uri, new HashMap<String, List<String>>());
            ArrayList cookies = new ArrayList(cookieHeaders.get("Cookie"));
            cookies.addAll(this.headers.values("Cookie"));
            if (!cookies.isEmpty()) {
                headers.add("Cookie", (Object)String.join((CharSequence)"; ", cookies));
            }
        }
        catch (IOException e) {
            throw new WebClientException("An error occurred while setting cookies.", e);
        }
        this.headers.toMap().forEach((arg_0, arg_1) -> ((HttpHeaders)headers).add(arg_0, arg_1));
        this.addHeaderIfAbsent((HttpHeaders)headers, HttpHeaderNames.HOST, this.uri.getHost() + ":" + this.uri.getPort());
        this.addHeaderIfAbsent((HttpHeaders)headers, HttpHeaderNames.CONNECTION, HttpHeaderValues.CLOSE);
        this.addHeaderIfAbsent((HttpHeaders)headers, HttpHeaderNames.ACCEPT_ENCODING, HttpHeaderValues.GZIP);
        this.addHeaderIfAbsent((HttpHeaders)headers, HttpHeaderNames.USER_AGENT, this.configuration.userAgent());
        return headers;
    }

    private void addHeaderIfAbsent(HttpHeaders headers, AsciiString header, Object headerValue) {
        if (!headers.contains((CharSequence)header)) {
            headers.set((CharSequence)header, headerValue);
        }
    }

    static {
        DEFAULT_SUPPORTED_PROTOCOLS.put(DEFAULT_TRANSPORT_PROTOCOL, 80);
        DEFAULT_SUPPORTED_PROTOCOLS.put("https", 443);
    }

    private static class ClientPath
    implements HttpRequest.Path {
        private final String path;
        private final String rawPath;
        private final Map<String, String> params;
        private final ClientPath absolutePath;
        private List<String> segments;

        ClientPath(String path, String rawPath, Map<String, String> params, ClientPath absolutePath) {
            this.path = path;
            this.rawPath = rawPath;
            this.params = params == null ? Collections.emptyMap() : params;
            this.absolutePath = absolutePath;
        }

        public String param(String name) {
            return this.params.get(name);
        }

        public List<String> segments() {
            List<String> result = this.segments;
            if (result == null) {
                StringTokenizer stok = new StringTokenizer(this.path, "/");
                result = new ArrayList<String>();
                while (stok.hasMoreTokens()) {
                    result.add(stok.nextToken());
                }
                this.segments = result;
            }
            return result;
        }

        public String toString() {
            return this.path;
        }

        public String toRawString() {
            return this.rawPath;
        }

        public HttpRequest.Path absolute() {
            return this.absolutePath == null ? this : this.absolutePath;
        }

        static HttpRequest.Path create(ClientPath contextual, String path, Map<String, String> params) {
            return ClientPath.create(contextual, path, path, params);
        }

        static HttpRequest.Path create(ClientPath contextual, String path, String rawPath, Map<String, String> params) {
            if (contextual == null) {
                return new ClientPath(path, rawPath, params, null);
            }
            return contextual.createSubpath(path, rawPath, params);
        }

        HttpRequest.Path createSubpath(String path, String rawPath, Map<String, String> params) {
            if (params == null) {
                params = Collections.emptyMap();
            }
            if (this.absolutePath == null) {
                HashMap<String, String> map = new HashMap<String, String>(this.params.size() + params.size());
                map.putAll(this.params);
                map.putAll(params);
                return new ClientPath(path, rawPath, params, new ClientPath(this.path, this.rawPath, map, null));
            }
            int size = this.params.size() + params.size() + this.absolutePath.params.size();
            HashMap<String, String> map = new HashMap<String, String>(size);
            map.putAll(this.absolutePath.params);
            map.putAll(this.params);
            map.putAll(params);
            return new ClientPath(path, rawPath, params, new ClientPath(this.absolutePath.path, this.absolutePath.rawPath, map, null));
        }
    }
}

