/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient;

import io.helidon.common.GenericType;
import io.helidon.common.context.Context;
import io.helidon.common.http.DataChunk;
import io.helidon.common.http.Headers;
import io.helidon.common.http.Http;
import io.helidon.common.http.HttpRequest;
import io.helidon.common.http.MediaType;
import io.helidon.common.http.Parameters;
import io.helidon.media.common.MessageBodyReaderContext;
import io.helidon.media.common.MessageBodyWriterContext;
import io.helidon.webclient.Proxy;
import io.helidon.webclient.WebClientRequestHeaders;
import io.helidon.webclient.WebClientResponse;
import java.net.URI;
import java.net.URL;
import java.time.temporal.TemporalUnit;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.function.Function;

public interface WebClientRequestBuilder {
    public WebClientRequestBuilder uri(String var1);

    public WebClientRequestBuilder uri(URL var1);

    public WebClientRequestBuilder uri(URI var1);

    public WebClientRequestBuilder skipUriEncoding();

    public WebClientRequestBuilder followRedirects(boolean var1);

    public WebClientRequestBuilder property(String var1, String var2);

    public WebClientRequestBuilder context(Context var1);

    public WebClientRequestHeaders headers();

    public WebClientRequestBuilder queryParam(String var1, String ... var2);

    public WebClientRequestBuilder proxy(Proxy var1);

    public WebClientRequestBuilder headers(Headers var1);

    public WebClientRequestBuilder headers(Function<WebClientRequestHeaders, Headers> var1);

    public WebClientRequestBuilder queryParams(Parameters var1);

    public MessageBodyReaderContext readerContext();

    public MessageBodyWriterContext writerContext();

    public WebClientRequestBuilder httpVersion(Http.Version var1);

    public WebClientRequestBuilder connectTimeout(long var1, TemporalUnit var3);

    public WebClientRequestBuilder readTimeout(long var1, TemporalUnit var3);

    public WebClientRequestBuilder fragment(String var1);

    public WebClientRequestBuilder path(HttpRequest.Path var1);

    public WebClientRequestBuilder path(String var1);

    public WebClientRequestBuilder contentType(MediaType var1);

    public WebClientRequestBuilder accept(MediaType ... var1);

    public <T> CompletionStage<T> request(Class<T> var1);

    public <T> CompletionStage<T> request(GenericType<T> var1);

    public CompletionStage<WebClientResponse> request();

    public CompletionStage<WebClientResponse> submit();

    public <T> CompletionStage<T> submit(Flow.Publisher<DataChunk> var1, Class<T> var2);

    public <T> CompletionStage<T> submit(Object var1, Class<T> var2);

    public CompletionStage<WebClientResponse> submit(Flow.Publisher<DataChunk> var1);

    public CompletionStage<WebClientResponse> submit(Object var1);

    public static interface ClientRequest
    extends HttpRequest {
        public WebClientRequestHeaders headers();

        public Map<String, String> properties();

        public Proxy proxy();

        public int redirectionCount();
    }
}

