/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient;

import io.helidon.common.HelidonFeatures;
import io.helidon.common.HelidonFlavor;
import io.helidon.common.context.Context;
import io.helidon.common.serviceloader.HelidonServiceLoader;
import io.helidon.config.Config;
import io.helidon.media.common.MediaSupport;
import io.helidon.webclient.NettyClient;
import io.helidon.webclient.Proxy;
import io.helidon.webclient.Ssl;
import io.helidon.webclient.WebClientConfiguration;
import io.helidon.webclient.WebClientException;
import io.helidon.webclient.WebClientRequestBuilder;
import io.helidon.webclient.spi.WebClientService;
import io.helidon.webclient.spi.WebClientServiceProvider;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;

public interface WebClient {
    public static WebClient create() {
        return WebClient.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public WebClientRequestBuilder put();

    public WebClientRequestBuilder get();

    public WebClientRequestBuilder method(String var1);

    public static final class Builder
    implements io.helidon.common.Builder<WebClient> {
        private final WebClientConfiguration.Builder<?, ?> configuration = NettyClient.SHARED_CONFIGURATION.get().derive();
        private final HelidonServiceLoader.Builder<WebClientServiceProvider> services = HelidonServiceLoader.builder(ServiceLoader.load(WebClientServiceProvider.class));
        private Config config = Config.empty();

        private Builder() {
        }

        public WebClient build() {
            return new NettyClient(this);
        }

        public Builder register(final WebClientService service) {
            this.services.addService((Object)new WebClientServiceProvider(){

                @Override
                public String configKey() {
                    return "ignored";
                }

                @Override
                public WebClientService create(Config config) {
                    return service;
                }
            });
            return this;
        }

        public Builder exclude(Class<? extends WebClientServiceProvider> providerClass) {
            this.services.addExcludedClass(providerClass);
            return this;
        }

        public Builder useSystemServiceLoader(boolean useServiceLoader) {
            this.services.useSystemServiceLoader(useServiceLoader);
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.configuration.proxy(proxy);
            return this;
        }

        public Builder mediaSupport(MediaSupport mediaSupport) {
            this.configuration.mediaSupport(mediaSupport);
            return this;
        }

        public Builder config(Config config) {
            this.config = config;
            this.configuration.config(config);
            return this;
        }

        public Builder connectTimeout(long amount, TemporalUnit unit) {
            this.configuration.connectTimeout(Duration.of(amount, unit));
            return this;
        }

        public Builder readTimeout(long amount, TemporalUnit unit) {
            this.configuration.readTimeout(Duration.of(amount, unit));
            return this;
        }

        public Builder ssl(Ssl ssl) {
            this.configuration.ssl(ssl);
            return this;
        }

        public Builder context(Context context) {
            this.configuration.context(context);
            return this;
        }

        public Builder addCookie(String name, String value) {
            this.configuration.defaultCookie(name, value);
            return this;
        }

        public Builder addHeader(String header, String ... value) {
            this.configuration.defaultHeader(header, Arrays.asList(value));
            return this;
        }

        public Builder baseUri(URI uri) {
            this.configuration.uri(uri);
            return this;
        }

        public Builder baseUri(String uri) {
            return this.baseUri(URI.create(uri));
        }

        public Builder baseUri(URL url) {
            try {
                return this.baseUri(url.toURI());
            }
            catch (URISyntaxException e) {
                throw new WebClientException("Failed to create URI from URL", e);
            }
        }

        public Builder followRedirects(boolean follow) {
            this.configuration.followRedirects(follow);
            return this;
        }

        public Builder userAgent(String userAgent) {
            this.configuration.userAgent(userAgent);
            return this;
        }

        WebClientConfiguration configuration() {
            this.configuration.clientServices(this.services());
            return this.configuration.build();
        }

        private List<WebClientService> services() {
            Config servicesConfig = this.config.get("services");
            ((List)servicesConfig.get("excludes").asList(String.class).orElse(Collections.emptyList())).forEach(arg_0 -> this.services.addExcludedClassName(arg_0));
            Config serviceConfig = servicesConfig.get("config");
            return this.services.build().asList().stream().map(it -> it.create(serviceConfig.get(it.configKey()))).collect(Collectors.toList());
        }

        static {
            HelidonFeatures.register((HelidonFlavor)HelidonFlavor.SE, (String[])new String[]{"WebClient"});
        }
    }
}

