/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient;

import io.helidon.config.Config;
import io.helidon.webclient.ProxyImpl;
import io.netty.channel.ChannelHandler;
import java.net.ProxySelector;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public interface Proxy {
    public static final Proxy NO_PROXY = Proxy.builder().build();

    public static Builder builder() {
        return new Builder();
    }

    public static Proxy noProxy() {
        return NO_PROXY;
    }

    public Optional<ChannelHandler> handler(URI var1);

    public static Proxy create(Config config) {
        return Proxy.builder().config(config).build();
    }

    public static Proxy create() {
        return Proxy.builder().useSystemSelector(true).build();
    }

    public static enum ProxyType {
        NONE,
        SYSTEM,
        HTTP,
        SOCKS_4,
        SOCKS_5;

    }

    public static class Builder
    implements io.helidon.common.Builder<Proxy> {
        private final Set<String> noProxyHosts = new HashSet<String>();
        private ProxyType type;
        private String host;
        private int port = 80;
        private String username;
        private char[] password;
        private ProxySelector systemSelector;

        public Proxy build() {
            if (null == this.host || this.host.isEmpty() && null == this.systemSelector) {
                return NO_PROXY;
            }
            return new ProxyImpl(this);
        }

        public Builder config(Config config) {
            config.get("use-system-selector").asBoolean().ifPresent(this::useSystemSelector);
            if (this.type != ProxyType.SYSTEM) {
                config.get("type").asString().map(ProxyType::valueOf).ifPresent(this::type);
                config.get("host").asString().ifPresent(this::host);
                config.get("port").asInt().ifPresent(this::port);
                config.get("username").asString().ifPresent(this::username);
                config.get("password").asString().map(String::toCharArray).ifPresent(this::password);
                config.get("no-proxy").asList(String.class).ifPresent(hosts -> hosts.forEach(this::addNoProxy));
            }
            return this;
        }

        public Builder type(ProxyType type) {
            this.type = type;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(char[] password) {
            this.password = Arrays.copyOf(password, password.length);
            return this;
        }

        public Builder addNoProxy(String noProxyHost) {
            this.noProxyHosts.add(noProxyHost);
            return this;
        }

        public Builder useSystemSelector(boolean useIt) {
            if (useIt) {
                this.type = ProxyType.SYSTEM;
                this.systemSelector = ProxySelector.getDefault();
            } else {
                if (this.type == ProxyType.SYSTEM) {
                    this.type = ProxyType.NONE;
                }
                this.systemSelector = null;
            }
            return this;
        }

        ProxyType type() {
            return this.type;
        }

        String host() {
            return this.host;
        }

        int port() {
            return this.port;
        }

        Set<String> noProxyHosts() {
            return new HashSet<String>(this.noProxyHosts);
        }

        Optional<String> username() {
            return Optional.ofNullable(this.username);
        }

        Optional<char[]> password() {
            return Optional.ofNullable(this.password);
        }

        ProxySelector systemSelector() {
            return this.systemSelector;
        }
    }
}

