/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.tracing;

import io.helidon.common.LazyValue;
import io.helidon.common.reactive.Single;
import io.helidon.tracing.HeaderConsumer;
import io.helidon.tracing.HeaderProvider;
import io.helidon.tracing.Span;
import io.helidon.tracing.SpanContext;
import io.helidon.tracing.Tag;
import io.helidon.tracing.Tracer;
import io.helidon.webclient.WebClientRequestHeaders;
import io.helidon.webclient.WebClientServiceRequest;
import io.helidon.webclient.spi.WebClientService;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class WebClientTracing
implements WebClientService {
    private static final int HTTP_STATUS_ERROR_THRESHOLD = 400;
    private static final int HTTP_STATUS_SERVER_ERROR_THRESHOLD = 500;

    private WebClientTracing() {
    }

    public static WebClientTracing create() {
        return new WebClientTracing();
    }

    public Single<WebClientServiceRequest> request(WebClientServiceRequest request) {
        String method = request.method().name().toUpperCase();
        Optional optionalTracer = request.context().get(Tracer.class);
        Tracer tracer = optionalTracer.orElseGet(Tracer::global);
        Span.Builder spanBuilder = tracer.spanBuilder(this.composeName(method, request));
        request.context().get(SpanContext.class).ifPresent(arg_0 -> ((Span.Builder)spanBuilder).parent(arg_0));
        spanBuilder.kind(Span.Kind.CLIENT);
        spanBuilder.tag(Tag.COMPONENT.create((Object)"helidon-webclient"));
        spanBuilder.tag(Tag.HTTP_METHOD.create((Object)method));
        spanBuilder.tag(Tag.HTTP_URL.create((Object)request.uri().toString()));
        Span span = spanBuilder.start();
        request.context().register((Object)span.context());
        tracer.inject(span.context(), HeaderProvider.empty(), (HeaderConsumer)new ClientHeaderConsumer(request.headers()));
        request.whenResponseReceived().thenAccept(response -> {
            int status = response.status().code();
            span.tag(Tag.HTTP_STATUS.create((Object)status));
            if (status >= 400) {
                span.status(Span.Status.ERROR);
                span.addEvent("error", Map.of("message", "Response HTTP status: " + status, "error.kind", status < 500 ? "ClientError" : "ServerError"));
            }
            span.end();
        }).exceptionallyAccept(arg_0 -> ((Span)span).end(arg_0));
        return Single.just((Object)request);
    }

    private String composeName(String method, WebClientServiceRequest request) {
        return method + "-" + request.schema() + "://" + request.host() + ":" + request.port() + request.path().toString();
    }

    private static class ClientHeaderConsumer
    implements HeaderConsumer {
        private final WebClientRequestHeaders headers;
        private final LazyValue<Map<String, List<String>>> headerMap;

        private ClientHeaderConsumer(WebClientRequestHeaders headers) {
            this.headers = headers;
            this.headerMap = LazyValue.create(() -> ((WebClientRequestHeaders)headers).toMap());
        }

        public void setIfAbsent(String key, String ... values) {
            this.headers.putIfAbsent(key, values);
        }

        public void set(String key, String ... values) {
            this.headers.put(key, values);
        }

        public Iterable<String> keys() {
            return ((Map)this.headerMap.get()).keySet();
        }

        public Optional<String> get(String key) {
            return this.headers.first(key);
        }

        public Iterable<String> getAll(String key) {
            return this.headers.all(key);
        }

        public boolean contains(String key) {
            return ((Map)this.headerMap.get()).containsKey(key);
        }
    }
}

