/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.jsonrpc;

import io.helidon.builder.api.RuntimeType;
import io.helidon.webclient.jsonrpc.JsonRpcClientBatchRequest;
import io.helidon.webclient.jsonrpc.JsonRpcClientConfig;
import io.helidon.webclient.jsonrpc.JsonRpcClientImpl;
import io.helidon.webclient.jsonrpc.JsonRpcClientProtocolConfig;
import io.helidon.webclient.jsonrpc.JsonRpcClientRequest;
import io.helidon.webclient.jsonrpc.JsonRpcProtocolProvider;
import io.helidon.webclient.spi.Protocol;
import java.util.function.Consumer;

@RuntimeType.PrototypedBy(value=JsonRpcClientConfig.class)
public interface JsonRpcClient
extends RuntimeType.Api<JsonRpcClientConfig> {
    public static final String PROTOCOL_ID = "jsonrpc";
    public static final Protocol<JsonRpcClient, JsonRpcClientProtocolConfig> PROTOCOL = JsonRpcProtocolProvider::new;

    public static JsonRpcClientConfig.Builder builder() {
        return JsonRpcClientConfig.builder();
    }

    public static JsonRpcClient create(JsonRpcClientConfig clientConfig) {
        return new JsonRpcClientImpl(clientConfig);
    }

    public static JsonRpcClient create(Consumer<JsonRpcClientConfig.Builder> consumer) {
        return JsonRpcClient.create(((JsonRpcClientConfig.Builder)JsonRpcClientConfig.builder().update(consumer)).buildPrototype());
    }

    public static JsonRpcClient create() {
        return JsonRpcClient.create(JsonRpcClientConfig.create());
    }

    public JsonRpcClientRequest rpcMethod(String var1);

    default public JsonRpcClientBatchRequest batch() {
        return this.batch("/");
    }

    public JsonRpcClientBatchRequest batch(String var1);
}

