/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.http2;

import io.helidon.common.buffers.BufferData;
import io.helidon.http.ClientRequestHeaders;
import io.helidon.http.ClientResponseHeaders;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.Headers;
import io.helidon.http.Method;
import io.helidon.http.Status;
import io.helidon.http.WritableHeaders;
import io.helidon.http.http2.Http2Headers;
import io.helidon.webclient.api.ClientRequest;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.api.HttpClientConfig;
import io.helidon.webclient.api.WebClientServiceRequest;
import io.helidon.webclient.api.WebClientServiceResponse;
import io.helidon.webclient.http2.Http2CallChainBase;
import io.helidon.webclient.http2.Http2ClientImpl;
import io.helidon.webclient.http2.Http2ClientRequest;
import io.helidon.webclient.http2.Http2ClientRequestImpl;
import io.helidon.webclient.http2.Http2ClientResponseImpl;
import io.helidon.webclient.http2.Http2ClientStream;
import io.helidon.webclient.http2.OutputStreamInterruptedException;
import io.helidon.webclient.http2.RedirectionProcessor;
import io.helidon.webclient.http2.StreamTimeoutException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.concurrent.CompletableFuture;

class Http2CallOutputStreamChain
extends Http2CallChainBase {
    private static final System.Logger LOGGER = System.getLogger(Http2CallOutputStreamChain.class.getName());
    private final CompletableFuture<WebClientServiceRequest> whenSent;
    private final ClientRequest.OutputStreamHandler streamHandler;

    Http2CallOutputStreamChain(Http2ClientImpl http2Client, Http2ClientRequestImpl http2ClientRequest, CompletableFuture<WebClientServiceRequest> whenSent, CompletableFuture<WebClientServiceResponse> whenComplete, ClientRequest.OutputStreamHandler streamHandler) {
        super(http2Client, http2ClientRequest, whenComplete, req -> req.outputStream(streamHandler));
        this.whenSent = whenSent;
        this.streamHandler = streamHandler;
    }

    @Override
    protected WebClientServiceResponse doProceed(WebClientServiceRequest serviceRequest, ClientRequestHeaders headers, Http2ClientStream stream) {
        boolean interrupted = false;
        ClientOutputStream outputStream = new ClientOutputStream(stream, (WritableHeaders<?>)headers, this.clientConfig(), serviceRequest, this.clientRequest(), this.whenSent, this.whenComplete());
        try {
            this.streamHandler.handle((OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (OutputStreamInterruptedException e) {
            interrupted = true;
        }
        if (interrupted || outputStream.interrupted()) {
            return outputStream.serviceResponse();
        }
        if (!outputStream.closed()) {
            throw new IllegalStateException("Output stream was not closed in handler");
        }
        Http2Headers responseHeaders = outputStream.stream.readHeaders();
        stream.ctx().log(LOGGER, System.Logger.Level.TRACE, "client received status %n%s", new Object[]{responseHeaders.status()});
        stream.ctx().log(LOGGER, System.Logger.Level.TRACE, "client received headers %n%s", new Object[]{responseHeaders.httpHeaders()});
        if (this.clientRequest().followRedirects() && RedirectionProcessor.redirectionStatusCode(responseHeaders.status())) {
            RedirectionProcessor.checkRedirectHeaders(responseHeaders);
            URI newUri = URI.create((String)responseHeaders.httpHeaders().get(HeaderNames.LOCATION).get());
            ClientUri redirectUri = ClientUri.create((URI)newUri);
            if (newUri.getHost() == null) {
                ClientUri resolvedUri = outputStream.lastRequest.resolvedUri();
                redirectUri.scheme(resolvedUri.scheme());
                redirectUri.host(resolvedUri.host());
                redirectUri.port(resolvedUri.port());
            }
            Http2ClientRequestImpl request = new Http2ClientRequestImpl(outputStream.lastRequest, Method.GET, redirectUri, outputStream.lastRequest.properties());
            int numberOfRedirects = outputStream.numberOfRedirects;
            Http2ClientResponseImpl clientResponse = RedirectionProcessor.invokeWithFollowRedirects(request, numberOfRedirects, BufferData.EMPTY_BYTES);
            return Http2CallOutputStreamChain.createServiceResponse(serviceRequest, this.clientConfig(), clientResponse.stream(), this.whenComplete(), clientResponse.status(), clientResponse.headers());
        }
        return Http2CallOutputStreamChain.createServiceResponse(serviceRequest, this.clientConfig(), outputStream.stream, this.whenComplete(), responseHeaders.status(), ClientResponseHeaders.create((Headers)responseHeaders.httpHeaders()));
    }

    private static class ClientOutputStream
    extends OutputStream {
        private static final BufferData TERMINATING = BufferData.empty();
        private final WebClientServiceRequest request;
        private final Http2ClientRequestImpl originalRequest;
        private final CompletableFuture<WebClientServiceRequest> whenSent;
        private final CompletableFuture<WebClientServiceResponse> whenComplete;
        private final HttpClientConfig clientConfig;
        private final WritableHeaders<?> headers;
        private final long contentLength;
        private long bytesWritten;
        private boolean noData = true;
        private boolean closed;
        private boolean interrupted;
        private int numberOfRedirects = 0;
        private Http2ClientStream stream;
        private Http2ClientRequestImpl lastRequest;
        private Http2ClientResponseImpl response;
        private WebClientServiceResponse serviceResponse;

        private ClientOutputStream(Http2ClientStream stream, WritableHeaders<?> headers, HttpClientConfig clientConfig, WebClientServiceRequest request, Http2ClientRequestImpl originalRequest, CompletableFuture<WebClientServiceRequest> whenSent, CompletableFuture<WebClientServiceResponse> whenComplete) {
            this.stream = stream;
            this.headers = headers;
            this.clientConfig = clientConfig;
            this.contentLength = headers.contentLength().orElse(-1L);
            this.request = request;
            this.originalRequest = originalRequest;
            this.lastRequest = originalRequest;
            this.whenSent = whenSent;
            this.whenComplete = whenComplete;
        }

        @Override
        public void write(int b) throws IOException {
            byte[] data = new byte[]{(byte)b};
            this.write(data, 0, 1);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.interrupted) {
                return;
            }
            if (this.closed) {
                throw new IOException("Output stream already closed");
            }
            BufferData data = BufferData.create((byte[])b, (int)off, (int)len);
            if (this.noData) {
                this.noData = false;
                this.sendHeader();
            }
            this.writeContent(data);
        }

        @Override
        public void close() throws IOException {
            if (this.closed || this.interrupted) {
                return;
            }
            this.closed = true;
            if (this.noData) {
                this.sendHeader();
            }
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                this.stream.ctx().log(LOGGER, System.Logger.Level.TRACE, "send data%n%s", new Object[]{TERMINATING.debugDataHex()});
            }
            this.stream.writeData(TERMINATING, true);
            super.close();
        }

        WebClientServiceResponse serviceResponse() {
            if (this.serviceResponse != null) {
                return this.serviceResponse;
            }
            return Http2CallChainBase.createServiceResponse(this.request, this.clientConfig, this.stream, this.whenComplete, this.response.status(), this.response.headers());
        }

        boolean closed() {
            return this.closed;
        }

        boolean interrupted() {
            return this.interrupted;
        }

        private void writeContent(BufferData buffer) throws IOException {
            this.bytesWritten += (long)buffer.available();
            if (this.contentLength != -1L && this.bytesWritten > this.contentLength) {
                throw new IOException("Content length was set to " + this.contentLength + ", but you are writing additional " + (this.bytesWritten - this.contentLength) + " bytes");
            }
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                this.stream.ctx().log(LOGGER, System.Logger.Level.TRACE, "send data:%n%s", new Object[]{buffer.debugDataHex()});
            }
            this.stream.writeData(buffer, false);
        }

        private void sendHeader() {
            Status status;
            if (this.clientConfig.sendExpectContinue() && !this.noData) {
                this.headers.set(HeaderValues.EXPECT_100);
            }
            if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                this.stream.ctx().log(LOGGER, System.Logger.Level.TRACE, "send headers:%n%s", new Object[]{this.headers});
            }
            Http2Headers http2Headers = Http2CallChainBase.prepareHeaders(this.request.method(), ClientRequestHeaders.create(this.headers), this.request.uri());
            this.stream.writeHeaders(http2Headers, false);
            this.whenSent.complete(this.request);
            if (this.headers.contains(HeaderValues.EXPECT_100) && (status = this.stream.waitFor100Continue()) != Status.CONTINUE_100) {
                Http2Headers responseHeaders = this.stream.readHeaders();
                Status responseStatus = responseHeaders.status();
                this.stream.ctx().log(LOGGER, System.Logger.Level.TRACE, "client received headers %n%s", new Object[]{responseHeaders});
                if (RedirectionProcessor.redirectionStatusCode(responseStatus) && this.originalRequest.followRedirects()) {
                    RedirectionProcessor.checkRedirectHeaders(responseHeaders);
                    this.redirect(responseStatus, responseHeaders.httpHeaders());
                } else {
                    this.interrupted = true;
                    this.serviceResponse = Http2CallChainBase.createServiceResponse(this.request, this.clientConfig, this.stream, this.whenComplete, responseHeaders.status(), ClientResponseHeaders.create((Headers)responseHeaders.httpHeaders()));
                    throw new OutputStreamInterruptedException();
                }
            }
        }

        private void redirect(Status lastStatus, Headers headerValues) {
            boolean sendEntity;
            Method method;
            String redirectedUri = (String)headerValues.get(HeaderNames.LOCATION).get();
            ClientUri lastUri = this.originalRequest.uri();
            if (lastStatus == Status.TEMPORARY_REDIRECT_307 || lastStatus == Status.PERMANENT_REDIRECT_308) {
                method = this.originalRequest.method();
                sendEntity = true;
            } else {
                method = Method.GET;
                sendEntity = false;
            }
            while (this.numberOfRedirects < this.clientConfig.maxRedirects()) {
                block15: {
                    URI newUri = URI.create(redirectedUri);
                    ClientUri redirectUri = ClientUri.create((URI)newUri);
                    if (newUri.getHost() == null) {
                        redirectUri.scheme(lastUri.scheme());
                        redirectUri.host(lastUri.host());
                        redirectUri.port(lastUri.port());
                    }
                    lastUri = redirectUri;
                    this.stream.close();
                    Http2ClientRequestImpl clientRequest = new Http2ClientRequestImpl(this.originalRequest, method, redirectUri, this.originalRequest.properties());
                    try {
                        Http2ClientResponseImpl response = sendEntity ? (Http2ClientResponseImpl)((Http2ClientRequest)((Http2ClientRequest)clientRequest.outputStreamRedirect(true).header(HeaderValues.EXPECT_100)).readTimeout(this.originalRequest.readContinueTimeout())).request() : (Http2ClientResponseImpl)clientRequest.outputStreamRedirect(false).request();
                        this.lastRequest = clientRequest;
                        this.stream = response.stream();
                        if (RedirectionProcessor.redirectionStatusCode(response.status())) {
                            try (Http2ClientResponseImpl http2ClientResponseImpl = response;){
                                RedirectionProcessor.checkRedirectHeaders(response.headers());
                                if (response.status() != Status.TEMPORARY_REDIRECT_307 && response.status() != Status.PERMANENT_REDIRECT_308) {
                                    method = Method.GET;
                                    sendEntity = false;
                                }
                                redirectedUri = (String)response.headers().get(HeaderNames.LOCATION).get();
                                break block15;
                            }
                        }
                        if (!sendEntity) {
                            this.interrupted = true;
                            this.response = response;
                            throw new OutputStreamInterruptedException();
                        }
                        return;
                    }
                    catch (StreamTimeoutException ignored) {
                        this.stream = ignored.stream();
                        return;
                    }
                }
                ++this.numberOfRedirects;
            }
            throw new IllegalStateException("Maximum number of request redirections (" + this.clientConfig.maxRedirects() + ") reached.");
        }
    }
}

