/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.http2;

import io.helidon.common.GenericType;
import io.helidon.common.buffers.BufferData;
import io.helidon.http.ClientRequestHeaders;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.WritableHeaders;
import io.helidon.http.http2.Http2Headers;
import io.helidon.http.media.EntityWriter;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.api.WebClientServiceRequest;
import io.helidon.webclient.api.WebClientServiceResponse;
import io.helidon.webclient.http2.Http2CallChainBase;
import io.helidon.webclient.http2.Http2ClientImpl;
import io.helidon.webclient.http2.Http2ClientRequestImpl;
import io.helidon.webclient.http2.Http2ClientStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;

class Http2CallEntityChain
extends Http2CallChainBase {
    private final CompletableFuture<WebClientServiceRequest> whenSent;
    private final Object entity;

    Http2CallEntityChain(Http2ClientImpl http2Client, Http2ClientRequestImpl request, CompletableFuture<WebClientServiceRequest> whenSent, CompletableFuture<WebClientServiceResponse> whenComplete, Object entity) {
        super(http2Client, request, whenComplete, it -> it.submit(entity));
        this.whenSent = whenSent;
        this.entity = entity;
    }

    @Override
    protected WebClientServiceResponse doProceed(WebClientServiceRequest serviceRequest, ClientRequestHeaders headers, Http2ClientStream stream) {
        byte[] entityBytes = this.entity == BufferData.EMPTY_BYTES ? BufferData.EMPTY_BYTES : this.entityBytes(this.entity, headers);
        if (!this.clientRequest().outputStreamRedirect()) {
            headers.set(HeaderValues.create((HeaderName)HeaderNames.CONTENT_LENGTH, (int)entityBytes.length));
        }
        ClientUri uri = serviceRequest.uri();
        Http2Headers http2Headers = Http2CallEntityChain.prepareHeaders(serviceRequest.method(), headers, uri);
        stream.writeHeaders(http2Headers, !this.clientRequest().outputStreamRedirect() && entityBytes.length == 0);
        stream.flowControl().inbound().incrementWindowSize(this.clientRequest().requestPrefetch());
        this.whenSent.complete(serviceRequest);
        stream.waitFor100Continue();
        if (entityBytes.length != 0) {
            stream.writeData(BufferData.create((byte[])entityBytes), true);
        }
        return this.readResponse(serviceRequest, stream);
    }

    private byte[] entityBytes(Object entity, ClientRequestHeaders headers) {
        if (entity instanceof byte[]) {
            byte[] bytes = (byte[])entity;
            return bytes;
        }
        GenericType genericType = GenericType.create((Object)entity);
        EntityWriter writer = this.clientConfig().mediaContext().writer(genericType, (WritableHeaders)headers);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        writer.write(genericType, entity, (OutputStream)bos, (WritableHeaders)headers);
        return bos.toByteArray();
    }
}

