/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.http2;

import io.helidon.common.buffers.BufferData;
import io.helidon.http.Header;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.Headers;
import io.helidon.http.http2.Http2Flag;
import io.helidon.http.http2.Http2Settings;
import io.helidon.webclient.api.ClientConnection;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.api.ConnectionKey;
import io.helidon.webclient.api.HttpClientResponse;
import io.helidon.webclient.api.TcpClientConnection;
import io.helidon.webclient.api.WebClient;
import io.helidon.webclient.http1.Http1Client;
import io.helidon.webclient.http1.Http1ClientRequest;
import io.helidon.webclient.http1.Http1ClientResponse;
import io.helidon.webclient.http1.UpgradeResponse;
import io.helidon.webclient.http2.Http2ClientConnection;
import io.helidon.webclient.http2.Http2ClientImpl;
import io.helidon.webclient.http2.Http2ClientProtocolConfig;
import io.helidon.webclient.http2.Http2ClientRequestImpl;
import io.helidon.webclient.http2.Http2ClientStream;
import io.helidon.webclient.http2.Http2ConnectionAttemptResult;
import java.util.Base64;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;

class Http2ClientConnectionHandler {
    private static final System.Logger LOGGER = System.getLogger(Http2ClientConnectionHandler.class.getName());
    private static final Header CONNECTION_UPGRADE_HEADER = HeaderValues.createCached((HeaderName)HeaderNames.CONNECTION, (String)"Upgrade, HTTP2-Settings");
    private static final Header UPGRADE_HEADER = HeaderValues.createCached((HeaderName)HeaderNames.UPGRADE, (String)"h2c");
    private static final HeaderName HTTP2_SETTINGS_HEADER = HeaderNames.create((String)"HTTP2-Settings");
    private final Map<ClientConnection, Http2ClientConnection> h2ConnByConn = Collections.synchronizedMap(new IdentityHashMap());
    private final Map<Http2ClientConnection, Boolean> allConnections = Collections.synchronizedMap(new IdentityHashMap());
    private final ConnectionKey connectionKey;
    private final AtomicReference<Http2ClientConnection> activeConnection = new AtomicReference();
    private final ReentrantLock lock = new ReentrantLock();
    private final AtomicReference<Http2ConnectionAttemptResult.Result> result = new AtomicReference<Http2ConnectionAttemptResult.Result>(Http2ConnectionAttemptResult.Result.UNKNOWN);

    Http2ClientConnectionHandler(ConnectionKey connectionKey) {
        this.connectionKey = connectionKey;
    }

    void close() {
        HashSet<Http2ClientConnection> toClose = new HashSet<Http2ClientConnection>(this.allConnections.keySet());
        toClose.forEach(Http2ClientConnection::close);
        this.activeConnection.set(null);
        this.allConnections.clear();
    }

    Http2ConnectionAttemptResult newStream(Http2ClientImpl http2Client, Http2ClientRequestImpl request, ClientUri initialUri, Function<Http1ClientRequest, Http1ClientResponse> http1EntityHandler) {
        return switch (this.result.get()) {
            default -> throw new MatchException(null, null);
            case Http2ConnectionAttemptResult.Result.HTTP_1 -> this.http1(http2Client, request, initialUri, http1EntityHandler);
            case Http2ConnectionAttemptResult.Result.HTTP_2 -> this.http2(http2Client, request, initialUri);
            case Http2ConnectionAttemptResult.Result.UNKNOWN -> this.httpX(http2Client, request, initialUri, http1EntityHandler);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Http2ConnectionAttemptResult http2(Http2ClientImpl http2Client, Http2ClientRequestImpl request, ClientUri initialUri) {
        try {
            this.lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Interrupted", e);
        }
        try {
            Http2ClientStream stream;
            Http2ClientConnection conn = this.activeConnection.updateAndGet(c -> c != null && c.closed() ? null : c);
            if (conn == null) {
                conn = this.createConnection(http2Client, request, initialUri);
                stream = conn.createStream(request);
            } else {
                stream = conn.tryStream(request);
                if (stream == null) {
                    conn = this.createConnection(http2Client, request, initialUri);
                    stream = conn.createStream(request);
                }
            }
            Http2ConnectionAttemptResult http2ConnectionAttemptResult = new Http2ConnectionAttemptResult(Http2ConnectionAttemptResult.Result.HTTP_2, stream, null);
            return http2ConnectionAttemptResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Http2ConnectionAttemptResult httpX(Http2ClientImpl http2Client, Http2ClientRequestImpl request, ClientUri initialUri, Function<Http1ClientRequest, Http1ClientResponse> http1EntityHandler) {
        try {
            this.lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Interrupted", e);
        }
        try {
            List<String> alpn;
            WebClient webClient = http2Client.webClient();
            if (request.tls().enabled() && "https".equals(initialUri.scheme())) {
                alpn = request.priorKnowledge() ? List.of("h2") : List.of("h2", "http/1.1");
                ClientConnection tcpClientConnection = this.connectClient(webClient, alpn);
                if (tcpClientConnection.helidonSocket().protocolNegotiated()) {
                    if ("h2".equals(tcpClientConnection.helidonSocket().protocol())) {
                        this.result.set(Http2ConnectionAttemptResult.Result.HTTP_2);
                        Http2ClientConnection connection = Http2ClientConnection.create(http2Client, tcpClientConnection, true);
                        this.allConnections.put(connection, true);
                        this.h2ConnByConn.put(tcpClientConnection, connection);
                        this.activeConnection.set(connection);
                        Http2ConnectionAttemptResult http2ConnectionAttemptResult = this.http2(http2Client, request, initialUri);
                        return http2ConnectionAttemptResult;
                    }
                    this.result.set(Http2ConnectionAttemptResult.Result.HTTP_1);
                    request.connection(tcpClientConnection);
                    Http2ConnectionAttemptResult http2ConnectionAttemptResult = this.http1(http2Client, request, initialUri, http1EntityHandler);
                    return http2ConnectionAttemptResult;
                }
                request.connection(tcpClientConnection);
            }
            if (this.result.get() != Http2ConnectionAttemptResult.Result.UNKNOWN) {
                alpn = this.http2(http2Client, request, initialUri);
                return alpn;
            }
            if (request.priorKnowledge()) {
                alpn = this.http2(http2Client, request, initialUri);
                return alpn;
            }
            UpgradeResponse upgradeResponse = ((Http1ClientRequest)((Http1ClientRequest)((Http1ClientRequest)this.http1Request(webClient, request, initialUri).header(UPGRADE_HEADER)).header(CONNECTION_UPGRADE_HEADER)).header(HTTP2_SETTINGS_HEADER, new String[]{this.settingsForUpgrade(http2Client.protocolConfig())})).upgrade("h2c");
            if (upgradeResponse.isUpgraded()) {
                this.result.set(Http2ConnectionAttemptResult.Result.HTTP_2);
                Http2ClientConnection conn = Http2ClientConnection.create(http2Client, upgradeResponse.connection(), false);
                this.activeConnection.set(conn);
                Http2ConnectionAttemptResult http2ConnectionAttemptResult = this.http2(http2Client, request, initialUri);
                return http2ConnectionAttemptResult;
            }
            this.result.set(Http2ConnectionAttemptResult.Result.HTTP_1);
            Http2ConnectionAttemptResult http2ConnectionAttemptResult = new Http2ConnectionAttemptResult(Http2ConnectionAttemptResult.Result.HTTP_1, null, upgradeResponse.response());
            return http2ConnectionAttemptResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    private String settingsForUpgrade(Http2ClientProtocolConfig protocolConfig) {
        Http2Settings settings = Http2ClientConnection.settings(protocolConfig);
        BufferData settingsFrameData = settings.toFrameData(null, 0, Http2Flag.SettingsFlags.create((int)0)).data();
        byte[] b = new byte[settingsFrameData.available()];
        settingsFrameData.read(b);
        return Base64.getEncoder().encodeToString(b);
    }

    private Http2ConnectionAttemptResult http1(Http2ClientImpl http2Client, Http2ClientRequestImpl request, ClientUri initialUri, Function<Http1ClientRequest, Http1ClientResponse> http1EntityHandler) {
        return new Http2ConnectionAttemptResult(Http2ConnectionAttemptResult.Result.HTTP_1, null, (HttpClientResponse)http1EntityHandler.apply(this.http1Request(http2Client.webClient(), request, initialUri)));
    }

    private Http1ClientRequest http1Request(WebClient webClient, Http2ClientRequestImpl request, ClientUri initialUri) {
        return (Http1ClientRequest)((Http1ClientRequest)((Http1ClientRequest)((Http1ClientRequest)((Http1ClientRequest)((Http1ClientRequest)((Http1ClientRequest)((Http1ClientRequest)((Http1ClientRequest)((Http1ClientRequest)((Http1Client)webClient.client(Http1Client.PROTOCOL)).method(request.method())).uri(initialUri)).keepAlive(request.keepAlive())).headers((Headers)request.headers())).skipUriEncoding(request.skipUriEncoding())).tls(request.tls())).readTimeout(request.readTimeout())).proxy(request.proxy())).maxRedirects(request.maxRedirects())).followRedirects(request.followRedirects());
    }

    private Http2ClientConnection createConnection(Http2ClientImpl http2Client, Http2ClientRequestImpl request, ClientUri requestUri) {
        Http2ClientConnection usedConnection;
        WebClient webClient = http2Client.webClient();
        Http2ClientProtocolConfig protocolConfig = http2Client.protocolConfig();
        Optional maybeConnection = request.connection();
        if (maybeConnection.isPresent()) {
            usedConnection = Http2ClientConnection.create(http2Client, (ClientConnection)maybeConnection.get(), true);
        } else {
            ClientConnection connection;
            if (request.tls().enabled() && "https".equals(requestUri.scheme())) {
                connection = this.connectClient(webClient, List.of("h2"));
                usedConnection = Http2ClientConnection.create(http2Client, connection, true);
            } else if (request.priorKnowledge()) {
                connection = this.connectClient(webClient, List.of("h2"));
                usedConnection = Http2ClientConnection.create(http2Client, connection, true);
            } else {
                UpgradeResponse upgradeResponse = ((Http1ClientRequest)((Http1ClientRequest)((Http1ClientRequest)this.http1Request(webClient, request, requestUri).header(UPGRADE_HEADER)).header(CONNECTION_UPGRADE_HEADER)).header(HTTP2_SETTINGS_HEADER, new String[]{this.settingsForUpgrade(protocolConfig)})).upgrade("h2c");
                if (upgradeResponse.isUpgraded()) {
                    this.result.set(Http2ConnectionAttemptResult.Result.HTTP_2);
                    connection = upgradeResponse.connection();
                    usedConnection = Http2ClientConnection.create(http2Client, connection, false);
                } else {
                    HttpClientResponse response = upgradeResponse.response();
                    try {
                        if (LOGGER.isLoggable(System.Logger.Level.TRACE)) {
                            upgradeResponse.connection().helidonSocket().log(LOGGER, System.Logger.Level.TRACE, "Failed to upgrade to HTTP/2", new Object[0]);
                        }
                        upgradeResponse.connection().closeResource();
                        throw new IllegalStateException("Failed to upgrade to HTTP/2, even though it succeeded before. Status: " + String.valueOf(response.status()));
                    }
                    catch (Throwable throwable) {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
            }
            this.activeConnection.set(usedConnection);
            this.allConnections.put(usedConnection, true);
            this.h2ConnByConn.put(connection, usedConnection);
        }
        return usedConnection;
    }

    private ClientConnection connectClient(WebClient webClient, List<String> alpn) {
        return TcpClientConnection.create((WebClient)webClient, (ConnectionKey)this.connectionKey, alpn, connection -> false, connection -> {
            Http2ClientConnection h2conn = this.h2ConnByConn.remove(connection);
            if (h2conn != null) {
                this.allConnections.remove(h2conn);
            }
        }).connect();
    }
}

